% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineStudents.R
\name{combineStudents}
\alias{combineStudents}
\title{Combine student data}
\usage{
combineStudents(inputdir = getwd(), outputdir = getwd(), quiet = FALSE)
}
\arguments{
\item{inputdir}{a string indicating the path were \code{\link{ILSAmerge}} files are stored.}

\item{outputdir}{a string indicating where the combined data will be saved.}

\item{quiet}{a logical value indicating if status of progress should be
shown. Default is \code{FALSE}.}
}
\value{
Saves combined student data produced by \code{\link{ILSAmerge}}.
}
\description{
Combines achievement and background student data merged by \code{\link{ILSAmerge}}.
To see which ILSA are available for combining use \code{\link{availableILSA}}.
}
\examples{
# Path were raw 'SPSS' files are
input <- system.file("extdata/timssadv", package = "ILSAmerge")

# Path were merged files will be saved
dir.create(file.path(tempdir(),"combineStudents"))
output <- file.path(tempdir(),"combineStudents")

# Merging 'TIMSS' Advanced 1995, as .rds file
ILSAmerge(inputdir = input, outputdir = output, filetype = "rds", quiet = FALSE)

# Rename files
ILSArename(output)

# Check file names
list.files(output,pattern = ".rds")

# Combine student files
combineStudents(inputdir = output, outputdir = output)

# Check file names
list.files(output,pattern = ".rds")

}
