% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/role.R
\name{Midlayer_role}
\alias{Midlayer_role}
\title{Analyzising role of interconnecting node in motifs}
\usage{
Midlayer_role(network.or.subnet_mat1, subnet_mat2 = NULL)
}
\arguments{
\item{network.or.subnet_mat1}{Either a multilayer(tripartite) network of 'igraph' class, or a numeric matrix(or data.frame) representing interactions between two groups of species. The network contains
interlayer links and without intralayer links. Each row and column of matrix represents the species in the first and second layers of the tripartite network respectively.
Elements of matrix are non-zero numebers if the interlayer species are connected, and 0 otherwise.}

\item{subnet_mat2}{A numeric matrix(or data.frame) representing interactions between two groups of species.Each row and column of matrix represents the species in the second and third layers of the
tripartite network respectively. Elements of matrix are non-zero numebers if the interlayer species are connected, and 0 otherwise. If \code{network.or.subnet_mat1} is "igraph", \code{subnet_mat2} defaults to NULL.

\strong{network.or.subnet_mat1}

There are two types of data that can be processed:
\itemize{
\item{Input in a network of type "igraph" alone.}

\item{Must be entered as data frame or matrix with \code{subnet_mat2}}}

About a network of type "igraph", It can be obtained from the connection matrices of subnetworks by the function \code{igraph_from_matrices}}
}
\value{
Returns a matrix of 65 columns representing the roles of interconnecting species in the motifs. Columns names are Role1, Role2, Role3 ... Role65.

Each row of matrix corresponds to a interconnecting species in the second layer of network. If a interconnecting species is linked to both the second and third level species, the elements in this row are not all zero, otherwise the elements are all zero.
}
\description{
Counting the number of 65 roles about interconnecting species in multilayer network motifs.
}
\examples{

set.seed(12)
d <- build_net(11,22,21,0.2)
mr <- Midlayer_role(d)
mr

set.seed(12)
MAT <- build_net(11,22,21,0.2,asmatrices=TRUE)

M <- Midlayer_role(MAT[[3]],MAT[[4]])
M

R<-rownames(MAT[[4]])[12]
MR<-MAT[[4]][12,]
MAT[[4]]<-MAT[[4]][-12,]
MAT[[4]]<-rbind(MAT[[4]],MR)
rownames(MAT[[4]])[22]<-R

Midlayer_role(MAT[[3]],MAT[[4]])

}
\references{
Simmons, B. I., Sweering, M. J., Schillinger, M., Dicks, L. V., Sutherland, W. J., & Di Clemente, R. (2019). bmotif: A package for motif analyses of bipartite networks. Methods in Ecology and Evolution, 10(5), 695-701.
}
