% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irc_ggm.R
\name{irc_ggm}
\alias{irc_ggm}
\title{Irrepresentable Condition: Gaussian Graphical Model}
\usage{
irc_ggm(true_network, cores = 2)
}
\arguments{
\item{true_network}{A matrix of dimensions \emph{p} by \emph{p}, assumed to be
a partial correlation matrix.}

\item{cores}{Integer. Number of cores for parallel computing (defaults to \code{2})}
}
\value{
infinity norm (greater than 1 the IRC is violated, with closer to zero better).
}
\description{
Check the IRC (or  Incoherence condition) in Gaussian graphical Models,
following Equation (8) in \insertCite{ravikumar2008model}{IRCcheck}.
}
\examples{
\donttest{
# generate network
net <- gen_net(p = 20, edge_prob = 0.3, lb = 0.05, ub = 0.3)

# check irc
irc_ggm(net$pcors)

# random adj 
# 90 \% sparsity (roughly)
p <- 20
adj <- matrix(sample(0:1, size = p^2, replace = TRUE, 
              prob = c(0.9, 0.1) ), 
              nrow = p, ncol = p)

adj <- symm_mat(adj)

diag(adj) <- 1

# random correlation matrix
set.seed(1)
cors <- cov2cor(
  solve(
  rWishart(1, p + 2, diag(p))[,,1])
)

# constrain to zero
net <- constrained(cors, adj = adj)

irc_ggm(net$wadj)


#' # random adj 
# 50 \% sparsity (roughly)
p <- 20
adj <- matrix(sample(0:1, size = p^2, replace = TRUE, prob = c(0.5, 0.5) ), 
              nrow = p, ncol = p)

adj <- symm_mat(adj)
diag(adj) <- 1

# random correlation matrix
set.seed(1)
cors <- cov2cor(
  solve(
  rWishart(1, p + 2, diag(p))[,,1])
)

# constrain to zero
net <- constrained(cors, adj = adj)

irc_ggm(net$wadj)

}
}
\references{
\insertAllCited{}
}
