\name{rotate2D}

\alias{rotate2D}


\title{Rotate horizontal components of a seismic signal}

\description{
The rotate2D() function rotates the two horizontal components of a
seismic signal into Radial and Transverse components returned as a list of 2 \code{Stream} objects.
}

\usage{
rotate2D(st1, st2, angle)
}

\arguments{
  \item{st1}{horizontal \code{Stream} from a channel set (channel name usually ending in "N", "E", "1", or "2")}
  \item{st2}{horizontal \code{Stream} from a channel set, complementary to st1}
  \item{angle}{angle (degrees) of the rotation}
}

\details{
The \code{rotation} web service returns Radial and Transverse seismic Streams, generated by
rotating \code{st1} and \code{st2} by \code{angle} degrees.

The rotation service uses the following transformation matrix to change the output vectors for 2-D horizontal transformations

\deqn{ M_{2D} = \left[ \begin{array}{cc} cos \alpha & sin \alpha \cr -sin \alpha & cos \alpha \end{array} \right] }

\deqn{ \left[ \begin{array}{c} R \cr T \end{array} \right] = M_{2D} \left[ \begin{array}{c} N \cr E \end{array} \right] }

where :
 \preformatted{
   N and E represent data from the original (horizontal) orientations.
   R and T represent the Radial and Transverse components.
   \eqn{\alpha} is the azimuth angle measured clockwise from north.
  }
}

\value{
A list of two \code{Stream} objects \code{stR} and \code{stT} is returned.
}

\note{
N and E are determined by the \code{Stream} @stats@azimuth values. If \code{Stream} @stats@azimuth values are not defined, 
st1 is assumed to be N and st2 is assumed to be E. Orthogonality is also assumed to be correct.
}

\references{
%% ~put references to the literature/web site here ~
IRIS DMC rotation web service documentation:

  \url{http://service.iris.edu/irisws/rotation/docs/1/help/}
}

\author{
Jonathan Callahan \email{jonathan@mazamascience.com}
}

%% \note{ }

%% ~Make other sections like Warning with \section{Warning }{....} ~

%% \seealso{ }

%% \examples{ }

