/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix2DTest;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseCCIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseCCMIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseRCIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseRCMIntMatrix2D;
import cern.jet.math.tint.IntFunctions;

public class SparseIntMatrix2DTest
extends IntMatrix2DTest {
    public SparseIntMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new SparseIntMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new SparseIntMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new SparseIntMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testGetRowCompressed() {
        int n;
        int n2;
        int n3 = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = Math.abs(this.rand.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(this.rand.nextInt() % this.NCOLUMNS);
            nArray3[i] = this.rand.nextInt();
        }
        SparseIntMatrix2D sparseIntMatrix2D = new SparseIntMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, nArray3);
        SparseRCIntMatrix2D sparseRCIntMatrix2D = sparseIntMatrix2D.getRowCompressed(false);
        for (n2 = 0; n2 < sparseIntMatrix2D.rows(); ++n2) {
            for (n = 0; n < sparseIntMatrix2D.columns(); ++n) {
                SparseIntMatrix2DTest.assertEquals((int)sparseIntMatrix2D.getQuick(n2, n), (int)sparseRCIntMatrix2D.getQuick(n2, n));
            }
        }
        sparseRCIntMatrix2D = sparseIntMatrix2D.getRowCompressed(true);
        for (n2 = 0; n2 < sparseIntMatrix2D.rows(); ++n2) {
            for (n = 0; n < sparseIntMatrix2D.columns(); ++n) {
                SparseIntMatrix2DTest.assertEquals((int)sparseIntMatrix2D.getQuick(n2, n), (int)sparseRCIntMatrix2D.getQuick(n2, n));
            }
        }
    }

    public void testGetRowCompressedModified() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Math.abs(this.rand.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(this.rand.nextInt() % this.NCOLUMNS);
            nArray3[i] = this.rand.nextInt();
        }
        SparseIntMatrix2D sparseIntMatrix2D = new SparseIntMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, nArray3);
        SparseRCMIntMatrix2D sparseRCMIntMatrix2D = sparseIntMatrix2D.getRowCompressedModified();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseIntMatrix2DTest.assertEquals((int)sparseIntMatrix2D.getQuick(i, j), (int)sparseRCMIntMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testGetColumnCompressed() {
        int n;
        int n2;
        int n3 = this.A.rows() * this.A.columns();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = Math.abs(this.rand.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(this.rand.nextInt() % this.NCOLUMNS);
            nArray3[i] = this.rand.nextInt();
        }
        SparseIntMatrix2D sparseIntMatrix2D = new SparseIntMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, nArray3);
        SparseCCIntMatrix2D sparseCCIntMatrix2D = sparseIntMatrix2D.getColumnCompressed(false);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                SparseIntMatrix2DTest.assertEquals((int)sparseIntMatrix2D.getQuick(n2, n), (int)sparseCCIntMatrix2D.getQuick(n2, n));
            }
        }
        sparseCCIntMatrix2D = sparseIntMatrix2D.getColumnCompressed(true);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                SparseIntMatrix2DTest.assertEquals((int)sparseIntMatrix2D.getQuick(n2, n), (int)sparseCCIntMatrix2D.getQuick(n2, n));
            }
        }
    }

    public void testGetColumnCompressedModified() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Math.abs(this.rand.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(this.rand.nextInt() % this.NCOLUMNS);
            nArray3[i] = this.rand.nextInt();
        }
        SparseIntMatrix2D sparseIntMatrix2D = new SparseIntMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, nArray3);
        SparseCCMIntMatrix2D sparseCCMIntMatrix2D = sparseIntMatrix2D.getColumnCompressedModified();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseIntMatrix2DTest.assertEquals((int)sparseIntMatrix2D.getQuick(i, j), (int)sparseCCMIntMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testAssignIntArrayIntArrayIntArrayIntIntFunction() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        DenseIntMatrix2D denseIntMatrix2D = new DenseIntMatrix2D(this.A.rows(), this.A.columns());
        for (int i = 0; i < n; ++i) {
            nArray[i] = i % this.A.rows();
            nArray2[i] = i % this.A.columns();
            nArray3[i] = this.rand.nextInt();
            ((IntMatrix2D)denseIntMatrix2D).setQuick(nArray[i], nArray2[i], nArray3[i]);
        }
        SparseIntMatrix2D sparseIntMatrix2D = new SparseIntMatrix2D(this.A.rows(), this.A.columns());
        sparseIntMatrix2D.assign(nArray, nArray2, nArray3, IntFunctions.multSecond(2));
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseIntMatrix2DTest.assertEquals((int)(2 * ((IntMatrix2D)denseIntMatrix2D).getQuick(i, j)), (int)sparseIntMatrix2D.getQuick(i, j));
            }
        }
    }
}

