/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.io;

public class VectorInfo {
    private boolean sparse;
    private VectorField field;

    public VectorInfo(boolean bl, VectorField vectorField) {
        this.sparse = bl;
        this.field = vectorField;
        this.validate();
    }

    private void validate() {
        if (this.isDense() && this.isPattern()) {
            throw new IllegalArgumentException("Vector cannot be dense with pattern storage");
        }
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public boolean isCoordinate() {
        return this.sparse;
    }

    public boolean isDense() {
        return !this.sparse;
    }

    public boolean isArray() {
        return !this.sparse;
    }

    public boolean isReal() {
        return this.field == VectorField.Real;
    }

    public boolean isInteger() {
        return this.field == VectorField.Integer;
    }

    public boolean isComplex() {
        return this.field == VectorField.Complex;
    }

    public boolean isPattern() {
        return this.field == VectorField.Pattern;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("%%MatrixMarket vector ");
        if (this.isSparse()) {
            stringBuilder.append("coordinate ");
        } else {
            stringBuilder.append("array ");
        }
        if (this.isReal()) {
            stringBuilder.append("real\n");
        } else if (this.isComplex()) {
            stringBuilder.append("complex\n");
        } else if (this.isPattern()) {
            stringBuilder.append("pattern\n");
        } else if (this.isInteger()) {
            stringBuilder.append("integer\n");
        } else {
            throw new IllegalArgumentException("Unknown field specification");
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VectorField {
        Real,
        Integer,
        Complex,
        Pattern;

    }
}

