/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SelectedDenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseCCLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseRCLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseLongMatrix2D
extends LongMatrix2D {
    static final long serialVersionUID = 1L;
    protected long[] elements;

    public DenseLongMatrix2D(long[][] lArray) {
        this(lArray.length, lArray.length == 0 ? 0 : lArray[0].length);
        this.assign(lArray);
    }

    public DenseLongMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new long[n * n2];
    }

    public DenseLongMatrix2D(int n, int n2, long[] lArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = lArray;
        this.isNoView = !bl;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(DenseLongMatrix2D.this.elements[n + n4 * DenseLongMatrix2D.this.rowStride]);
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < DenseLongMatrix2D.this.columns; ++j) {
                                l = longLongFunction.apply(l, longFunction.apply(DenseLongMatrix2D.this.elements[n + i * DenseLongMatrix2D.this.rowStride + j * DenseLongMatrix2D.this.columnStride]));
                            }
                            n2 = 0;
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.elements[n]);
            int n6 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n6; j < this.columns; ++j) {
                    l = longLongFunction.apply(l, longFunction.apply(this.elements[n + i * this.rowStride + j * this.columnStride]));
                }
                n6 = 0;
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, final LongProcedure longProcedure) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = DenseLongMatrix2D.this.elements[n + n4 * DenseLongMatrix2D.this.rowStride];
                        long l2 = 0L;
                        if (longProcedure.apply(l)) {
                            l2 = longFunction.apply(l);
                        }
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < DenseLongMatrix2D.this.columns; ++j) {
                                l = DenseLongMatrix2D.this.elements[n + i * DenseLongMatrix2D.this.rowStride + j * DenseLongMatrix2D.this.columnStride];
                                if (!longProcedure.apply(l)) continue;
                                l2 = longLongFunction.apply(l2, longFunction.apply(l));
                            }
                            n2 = 0;
                        }
                        return l2;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            long l2 = this.elements[n];
            if (longProcedure.apply(l2)) {
                l = longFunction.apply(this.elements[n]);
            }
            int n6 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n6; j < this.columns; ++j) {
                    l2 = this.elements[n + i * this.rowStride + j * this.columnStride];
                    if (!longProcedure.apply(l2)) continue;
                    l = longLongFunction.apply(l, longFunction.apply(l2));
                }
                n6 = 0;
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        int n2 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        long l = 0L;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, n2);
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n2 : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(DenseLongMatrix2D.this.elements[n + nArray[n5] * DenseLongMatrix2D.this.rowStride + nArray2[n5] * DenseLongMatrix2D.this.columnStride]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            long l2 = DenseLongMatrix2D.this.elements[n + nArray[i] * DenseLongMatrix2D.this.rowStride + nArray2[i] * DenseLongMatrix2D.this.columnStride];
                            l = longLongFunction.apply(l, longFunction.apply(l2));
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.elements[n + nArray[0] * this.rowStride + nArray2[0] * this.columnStride]);
            for (int i = 1; i < n2; ++i) {
                long l2 = this.elements[n + nArray[i] * this.rowStride + nArray2[i] * this.columnStride];
                l = longLongFunction.apply(l, longFunction.apply(l2));
            }
        }
        return l;
    }

    public long aggregate(LongMatrix2D longMatrix2D, final LongLongFunction longLongFunction, final LongLongFunction longLongFunction2) {
        if (!(longMatrix2D instanceof DenseLongMatrix2D)) {
            return super.aggregate(longMatrix2D, longLongFunction, longLongFunction2);
        }
        this.checkShape(longMatrix2D);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)longMatrix2D.index(0, 0);
        final int n3 = longMatrix2D.rowStride();
        final int n4 = longMatrix2D.columnStride();
        final long[] lArray = (long[])longMatrix2D.elements();
        long l = 0L;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longLongFunction2.apply(DenseLongMatrix2D.this.elements[n + n7 * DenseLongMatrix2D.this.rowStride], lArray[n2 + n7 * n3]);
                        int n5 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n5; j < DenseLongMatrix2D.this.columns; ++j) {
                                l = longLongFunction.apply(l, longLongFunction2.apply(DenseLongMatrix2D.this.elements[n + i * DenseLongMatrix2D.this.rowStride + j * DenseLongMatrix2D.this.columnStride], lArray[n2 + i * n3 + j * n4]));
                            }
                            n5 = 0;
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            int n9 = 1;
            l = longLongFunction2.apply(this.elements[n], lArray[n2]);
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    l = longLongFunction.apply(l, longLongFunction2.apply(this.elements[n + i * this.rowStride + j * this.columnStride], lArray[n2 + i * n3 + j * n4]));
                }
                n9 = 0;
            }
        }
        return l;
    }

    public LongMatrix2D assign(final LongFunction longFunction) {
        final long[] lArray = this.elements;
        if (lArray == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (longFunction instanceof LongMult) {
                long l = ((LongMult)longFunction).multiplicator;
                if (l == 1L) {
                    return this;
                }
                if (l == 0L) {
                    return this.assign(0L);
                }
            }
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseLongMatrix2D.this.rowStride;
                        if (longFunction instanceof LongMult) {
                            long l = ((LongMult)longFunction).multiplicator;
                            if (l == 1L) {
                                return;
                            }
                            for (int i = n4; i < n5; ++i) {
                                int n2 = n6;
                                for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                    int n3 = n2;
                                    lArray[n3] = lArray[n3] * l;
                                    n2 += DenseLongMatrix2D.this.columnStride;
                                }
                                n6 += DenseLongMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                int n42 = n6;
                                for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                    lArray[n42] = longFunction.apply(lArray[n42]);
                                    n42 += DenseLongMatrix2D.this.columnStride;
                                }
                                n6 += DenseLongMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            if (longFunction instanceof LongMult) {
                long l = ((LongMult)longFunction).multiplicator;
                if (l == 1L) {
                    return this;
                }
                if (l == 0L) {
                    return this.assign(0L);
                }
                for (int i = 0; i < this.rows; ++i) {
                    int n7 = n6;
                    for (int j = 0; j < this.columns; ++j) {
                        int n8 = n7;
                        lArray[n8] = lArray[n8] * l;
                        n7 += this.columnStride;
                    }
                    n6 += this.rowStride;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n9 = n6;
                    for (int j = 0; j < this.columns; ++j) {
                        lArray[n9] = longFunction.apply(lArray[n9]);
                        n9 += this.columnStride;
                    }
                    n6 += this.rowStride;
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongProcedure longProcedure, final LongFunction longFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseLongMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                long l = DenseLongMatrix2D.this.elements[n2];
                                if (longProcedure.apply(l)) {
                                    DenseLongMatrix2D.this.elements[n2] = longFunction.apply(l);
                                }
                                n2 += DenseLongMatrix2D.this.columnStride;
                            }
                            n3 += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    long l = this.elements[n7];
                    if (longProcedure.apply(l)) {
                        this.elements[n7] = longFunction.apply(l);
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongProcedure longProcedure, final long l) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseLongMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                long l2 = DenseLongMatrix2D.this.elements[n2];
                                if (longProcedure.apply(l2)) {
                                    DenseLongMatrix2D.this.elements[n2] = l;
                                }
                                n2 += DenseLongMatrix2D.this.columnStride;
                            }
                            n3 += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    long l2 = this.elements[n7];
                    if (longProcedure.apply(l2)) {
                        this.elements[n7] = l;
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long l) {
        final long[] lArray = this.elements;
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseLongMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                lArray[n2] = l;
                                n2 += DenseLongMatrix2D.this.columnStride;
                            }
                            n3 += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    lArray[n7] = l;
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long[] lArray) {
        if ((long)lArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + lArray.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(lArray, 0, this.elements, 0, lArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n3 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n - 1 ? this.rows : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseLongMatrix2D.this.columns;
                            int n22 = n2 + n4 * DenseLongMatrix2D.this.rowStride;
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n22;
                                for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                    DenseLongMatrix2D.this.elements[n3] = lArray[n++];
                                    n3 += DenseLongMatrix2D.this.columnStride;
                                }
                                n22 += DenseLongMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = 0;
                int n7 = n2;
                for (int i = 0; i < this.rows; ++i) {
                    int n8 = n7;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n8] = lArray[n6++];
                        n8 += this.columnStride;
                    }
                    n7 += this.rowStride;
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final int[] nArray) {
        if ((long)nArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + nArray.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 * DenseLongMatrix2D.this.columns;
                        int n22 = n2 + n4 * DenseLongMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n3 = n22;
                            for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                DenseLongMatrix2D.this.elements[n3] = nArray[n++];
                                n3 += DenseLongMatrix2D.this.columnStride;
                            }
                            n22 += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            int n7 = n2;
            for (int i = 0; i < this.rows; ++i) {
                int n8 = n7;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n8] = nArray[n6++];
                    n8 += this.columnStride;
                }
                n7 += this.rowStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long[][] lArray) {
        if (lArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + lArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n2 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.rows : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n3 * DenseLongMatrix2D.this.rowStride;
                            for (int i = n3; i < n4; ++i) {
                                long[] lArray2 = lArray[i];
                                if (lArray2.length != DenseLongMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray2.length + "columns()=" + DenseLongMatrix2D.this.columns());
                                }
                                System.arraycopy(lArray2, 0, DenseLongMatrix2D.this.elements, n, DenseLongMatrix2D.this.columns);
                                n += DenseLongMatrix2D.this.columns;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = 0;
                for (int i = 0; i < this.rows; ++i) {
                    long[] lArray2 = lArray[i];
                    if (lArray2.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray2.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(lArray2, 0, this.elements, n5, this.columns);
                    n5 += this.columns;
                }
            }
        } else {
            final int n6 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n7 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n8 = i * n7;
                    final int n9 = i == n - 1 ? this.rows : n8 + n7;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n6 + n8 * DenseLongMatrix2D.this.rowStride;
                            for (int i = n8; i < n9; ++i) {
                                long[] lArray2 = lArray[i];
                                if (lArray2.length != DenseLongMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray2.length + "columns()=" + DenseLongMatrix2D.this.columns());
                                }
                                int n2 = n;
                                for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                    DenseLongMatrix2D.this.elements[n2] = lArray2[j];
                                    n2 += DenseLongMatrix2D.this.columnStride;
                                }
                                n += DenseLongMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = n6;
                for (int i = 0; i < this.rows; ++i) {
                    long[] lArray3 = lArray[i];
                    if (lArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray3.length + "columns()=" + this.columns());
                    }
                    int n11 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n11] = lArray3[j];
                        n11 += this.columnStride;
                    }
                    n10 += this.rowStride;
                }
            }
            return this;
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D) {
        Object object;
        if (!(longMatrix2D instanceof DenseLongMatrix2D)) {
            super.assign(longMatrix2D);
            return this;
        }
        DenseLongMatrix2D denseLongMatrix2D = (DenseLongMatrix2D)longMatrix2D;
        if (denseLongMatrix2D == this) {
            return this;
        }
        this.checkShape(denseLongMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseLongMatrix2D.isNoView) {
            System.arraycopy(denseLongMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        DenseLongMatrix2D denseLongMatrix2D2 = (DenseLongMatrix2D)longMatrix2D;
        if (this.haveSharedCells(denseLongMatrix2D2)) {
            object = denseLongMatrix2D2.copy();
            if (!(object instanceof DenseLongMatrix2D)) {
                super.assign(denseLongMatrix2D2);
                return this;
            }
            denseLongMatrix2D2 = (DenseLongMatrix2D)object;
        }
        object = denseLongMatrix2D2.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n2 = (int)denseLongMatrix2D2.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        int n4 = denseLongMatrix2D2.columnStride;
        final int n5 = denseLongMatrix2D2.rowStride;
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n6 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((long[])object, n4){
                    final /* synthetic */ long[] val$elemsOther;
                    final /* synthetic */ int val$columnStrideOther;
                    {
                        this.val$elemsOther = lArray;
                        this.val$columnStrideOther = n6;
                    }

                    public void run() {
                        int n = n3 + n7 * DenseLongMatrix2D.this.rowStride;
                        int n22 = n2 + n7 * n5;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n;
                            int n4 = n22;
                            for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                DenseLongMatrix2D.this.elements[n32] = this.val$elemsOther[n4];
                                n32 += DenseLongMatrix2D.this.columnStride;
                                n4 += this.val$columnStrideOther;
                            }
                            n += DenseLongMatrix2D.this.rowStride;
                            n22 += n5;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n3;
            int n10 = n2;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n11] = (long)object[n12];
                    n11 += this.columnStride;
                    n12 += n4;
                }
                n9 += this.rowStride;
                n10 += n5;
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D, final LongLongFunction longLongFunction) {
        if (!(longMatrix2D instanceof DenseLongMatrix2D)) {
            super.assign(longMatrix2D, longLongFunction);
            return this;
        }
        DenseLongMatrix2D denseLongMatrix2D = (DenseLongMatrix2D)longMatrix2D;
        this.checkShape(longMatrix2D);
        final long[] lArray = denseLongMatrix2D.elements;
        if (this.elements == null || lArray == null) {
            throw new InternalError();
        }
        final int n = (int)denseLongMatrix2D.index(0, 0);
        final int n2 = (int)this.index(0, 0);
        final int n3 = denseLongMatrix2D.columnStride;
        final int n4 = denseLongMatrix2D.rowStride;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            long l;
            if (longLongFunction instanceof LongPlusMultSecond && (l = ((LongPlusMultSecond)longLongFunction).multiplicator) == 0L) {
                return this;
            }
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        if (longLongFunction == LongFunctions.mult) {
                            int n25 = n2 + n7 * DenseLongMatrix2D.this.rowStride;
                            int n26 = n + n7 * n4;
                            for (int i = n7; i < n8; ++i) {
                                int n32 = n25;
                                int n42 = n26;
                                for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                    int n5 = n32;
                                    DenseLongMatrix2D.this.elements[n5] = DenseLongMatrix2D.this.elements[n5] * lArray[n42];
                                    n32 += DenseLongMatrix2D.this.columnStride;
                                    n42 += n3;
                                }
                                n25 += DenseLongMatrix2D.this.rowStride;
                                n26 += n4;
                            }
                        } else if (longLongFunction == LongFunctions.div) {
                            int n27 = n2 + n7 * DenseLongMatrix2D.this.rowStride;
                            int n6 = n + n7 * n4;
                            for (int i = n7; i < n8; ++i) {
                                int n72 = n27;
                                int n82 = n6;
                                for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                    int n9 = n72;
                                    DenseLongMatrix2D.this.elements[n9] = DenseLongMatrix2D.this.elements[n9] / lArray[n82];
                                    n72 += DenseLongMatrix2D.this.columnStride;
                                    n82 += n3;
                                }
                                n27 += DenseLongMatrix2D.this.rowStride;
                                n6 += n4;
                            }
                        } else if (longLongFunction instanceof LongPlusMultSecond) {
                            long l = ((LongPlusMultSecond)longLongFunction).multiplicator;
                            if (l == 1L) {
                                int n28 = n2 + n7 * DenseLongMatrix2D.this.rowStride;
                                int n10 = n + n7 * n4;
                                for (int i = n7; i < n8; ++i) {
                                    int n11 = n28;
                                    int n12 = n10;
                                    for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                        int n13 = n11;
                                        DenseLongMatrix2D.this.elements[n13] = DenseLongMatrix2D.this.elements[n13] + lArray[n12];
                                        n11 += DenseLongMatrix2D.this.columnStride;
                                        n12 += n3;
                                    }
                                    n28 += DenseLongMatrix2D.this.rowStride;
                                    n10 += n4;
                                }
                            } else if (l == -1L) {
                                int n29 = n2 + n7 * DenseLongMatrix2D.this.rowStride;
                                int n14 = n + n7 * n4;
                                for (int i = n7; i < n8; ++i) {
                                    int n15 = n29;
                                    int n16 = n14;
                                    for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                        int n17 = n15;
                                        DenseLongMatrix2D.this.elements[n17] = DenseLongMatrix2D.this.elements[n17] - lArray[n16];
                                        n15 += DenseLongMatrix2D.this.columnStride;
                                        n16 += n3;
                                    }
                                    n29 += DenseLongMatrix2D.this.rowStride;
                                    n14 += n4;
                                }
                            } else {
                                int n30 = n2 + n7 * DenseLongMatrix2D.this.rowStride;
                                int n18 = n + n7 * n4;
                                for (int i = n7; i < n8; ++i) {
                                    int n19 = n30;
                                    int n20 = n18;
                                    for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                        int n21 = n19;
                                        DenseLongMatrix2D.this.elements[n21] = DenseLongMatrix2D.this.elements[n21] + l * lArray[n20];
                                        n19 += DenseLongMatrix2D.this.columnStride;
                                        n20 += n3;
                                    }
                                    n30 += DenseLongMatrix2D.this.rowStride;
                                    n18 += n4;
                                }
                            }
                        } else {
                            int n31 = n2 + n7 * DenseLongMatrix2D.this.rowStride;
                            int n22 = n + n7 * n4;
                            for (int i = n7; i < n8; ++i) {
                                int n23 = n31;
                                int n24 = n22;
                                for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                    DenseLongMatrix2D.this.elements[n23] = longLongFunction.apply(DenseLongMatrix2D.this.elements[n23], lArray[n24]);
                                    n23 += DenseLongMatrix2D.this.columnStride;
                                    n24 += n3;
                                }
                                n31 += DenseLongMatrix2D.this.rowStride;
                                n22 += n4;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else if (longLongFunction == LongFunctions.mult) {
            int n9 = n2;
            int n10 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    int n13 = n11;
                    this.elements[n13] = this.elements[n13] * lArray[n12];
                    n11 += this.columnStride;
                    n12 += n3;
                }
                n9 += this.rowStride;
                n10 += n4;
            }
        } else if (longLongFunction == LongFunctions.div) {
            int n14 = n2;
            int n15 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n16 = n14;
                int n17 = n15;
                for (int j = 0; j < this.columns; ++j) {
                    int n18 = n16;
                    this.elements[n18] = this.elements[n18] / lArray[n17];
                    n16 += this.columnStride;
                    n17 += n3;
                }
                n14 += this.rowStride;
                n15 += n4;
            }
        } else if (longLongFunction instanceof LongPlusMultSecond) {
            long l = ((LongPlusMultSecond)longLongFunction).multiplicator;
            if (l == 0L) {
                return this;
            }
            if (l == 1L) {
                int n19 = n2;
                int n20 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n21 = n19;
                    int n22 = n20;
                    for (int j = 0; j < this.columns; ++j) {
                        int n23 = n21;
                        this.elements[n23] = this.elements[n23] + lArray[n22];
                        n21 += this.columnStride;
                        n22 += n3;
                    }
                    n19 += this.rowStride;
                    n20 += n4;
                }
            } else if (l == -1L) {
                int n24 = n2;
                int n25 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n26 = n24;
                    int n27 = n25;
                    for (int j = 0; j < this.columns; ++j) {
                        int n28 = n26;
                        this.elements[n28] = this.elements[n28] - lArray[n27];
                        n26 += this.columnStride;
                        n27 += n3;
                    }
                    n24 += this.rowStride;
                    n25 += n4;
                }
            } else {
                int n29 = n2;
                int n30 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n31 = n29;
                    int n32 = n30;
                    for (int j = 0; j < this.columns; ++j) {
                        int n33 = n31;
                        this.elements[n33] = this.elements[n33] + l * lArray[n32];
                        n31 += this.columnStride;
                        n32 += n3;
                    }
                    n29 += this.rowStride;
                    n30 += n4;
                }
            }
        } else {
            int n34 = n2;
            int n35 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n36 = n34;
                int n37 = n35;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n36] = longLongFunction.apply(this.elements[n36], lArray[n37]);
                    n36 += this.columnStride;
                    n37 += n3;
                }
                n34 += this.rowStride;
                n35 += n4;
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D, final LongLongFunction longLongFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(longMatrix2D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final long[] lArray = (long[])longMatrix2D.elements();
        final int n2 = (int)longMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = longMatrix2D.columnStride();
        final int n5 = longMatrix2D.rowStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, n);
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n = n3 + nArray[i] * DenseLongMatrix2D.this.rowStride + nArray2[i] * DenseLongMatrix2D.this.columnStride;
                            int n22 = n2 + nArray[i] * n5 + nArray2[i] * n4;
                            DenseLongMatrix2D.this.elements[n] = longLongFunction.apply(DenseLongMatrix2D.this.elements[n], lArray[n22]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                int n10 = n3 + nArray[i] * this.rowStride + nArray2[i] * this.columnStride;
                int n11 = n2 + nArray[i] * n5 + nArray2[i] * n4;
                this.elements[n10] = longLongFunction.apply(this.elements[n10], lArray[n11]);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            Long[] longArray = new Long[n2];
            int n5 = this.rows / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n2 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int n = 0;
                        int n2 = n3 + n6 * DenseLongMatrix2D.this.rowStride;
                        for (int i = n6; i < n7; ++i) {
                            int n32 = n2;
                            for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                if (DenseLongMatrix2D.this.elements[n32] != 0L) {
                                    ++n;
                                }
                                n32 += DenseLongMatrix2D.this.columnStride;
                            }
                            n2 += DenseLongMatrix2D.this.rowStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    longArray[n4] = (Long)futureArray[n4].get();
                }
                n = longArray[0].intValue();
                for (n4 = 1; n4 < n2; ++n4) {
                    n += longArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n9 = n8;
                for (int j = 0; j < this.columns; ++j) {
                    if (this.elements[n9] != 0L) {
                        ++n;
                    }
                    n9 += this.columnStride;
                }
                n8 += this.rowStride;
            }
        }
        return n;
    }

    public long[] elements() {
        return this.elements;
    }

    public LongMatrix2D forEachNonZero(final IntIntLongFunction intIntLongFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseLongMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                long l = DenseLongMatrix2D.this.elements[n2];
                                if (l != 0L) {
                                    DenseLongMatrix2D.this.elements[n2] = intIntLongFunction.apply(i, j, l);
                                }
                                n2 += DenseLongMatrix2D.this.columnStride;
                            }
                            n3 += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    long l = this.elements[n7];
                    if (l != 0L) {
                        this.elements[n7] = intIntLongFunction.apply(i, j, l);
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        longArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                long l = this.elements[n2];
                if (l < 0L) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    longArrayList.add(l);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        longArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                long l = this.elements[n2];
                if (l != 0L) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    longArrayList.add(l);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        longArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                long l = this.elements[n2];
                if (l > 0L) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    longArrayList.add(l);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public long getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public LongMatrix2D like(int n, int n2) {
        return new DenseLongMatrix2D(n, n2);
    }

    public LongMatrix1D like1D(int n) {
        return new DenseLongMatrix1D(n);
    }

    public long[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        long l = 0L;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.rows);
            Future[] futureArray = new Future[n4];
            long[][] lArray = new long[n4][2];
            int n6 = this.rows / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.rows : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        long l = DenseLongMatrix2D.this.elements[n3 + n7 * DenseLongMatrix2D.this.rowStride];
                        int n = n7;
                        int n2 = 0;
                        int n32 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n32; j < DenseLongMatrix2D.this.columns; ++j) {
                                long l2 = DenseLongMatrix2D.this.elements[n3 + i * DenseLongMatrix2D.this.rowStride + j * DenseLongMatrix2D.this.columnStride];
                                if (l >= l2) continue;
                                l = l2;
                                n = i;
                                n2 = j;
                            }
                            n32 = 0;
                        }
                        return new long[]{l, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    lArray[n5] = (long[])futureArray[n5].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                n2 = (int)lArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (l >= lArray[n5][0]) continue;
                    l = lArray[n5][0];
                    n = (int)lArray[n5][1];
                    n2 = (int)lArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.elements[n3];
            int n9 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    long l2 = this.elements[n3 + i * this.rowStride + j * this.columnStride];
                    if (l >= l2) continue;
                    l = l2;
                    n = i;
                    n2 = j;
                }
                n9 = 0;
            }
        }
        return new long[]{l, n, n2};
    }

    public long[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        long l = 0L;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.rows);
            Future[] futureArray = new Future[n4];
            long[][] lArray = new long[n4][2];
            int n6 = this.rows / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.rows : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n = n7;
                        int n2 = 0;
                        long l = DenseLongMatrix2D.this.elements[n3 + n7 * DenseLongMatrix2D.this.rowStride];
                        int n32 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n32; j < DenseLongMatrix2D.this.columns; ++j) {
                                long l2 = DenseLongMatrix2D.this.elements[n3 + i * DenseLongMatrix2D.this.rowStride + j * DenseLongMatrix2D.this.columnStride];
                                if (l <= l2) continue;
                                l = l2;
                                n = i;
                                n2 = j;
                            }
                            n32 = 0;
                        }
                        return new long[]{l, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    lArray[n5] = (long[])futureArray[n5].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                n2 = (int)lArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (l <= lArray[n5][0]) continue;
                    l = lArray[n5][0];
                    n = (int)lArray[n5][1];
                    n2 = (int)lArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.elements[n3];
            int n9 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    long l2 = this.elements[n3 + i * this.rowStride + j * this.columnStride];
                    if (l <= l2) continue;
                    l = l2;
                    n = i;
                    n2 = j;
                }
                n9 = 0;
            }
        }
        return new long[]{l, n, n2};
    }

    public void setQuick(int n, int n2, long l) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = l;
    }

    public long[][] toArray() {
        final long[][] lArray = new long[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + n4 * DenseLongMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            long[] lArray2 = lArray[i];
                            int n22 = n;
                            for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                lArray2[j] = DenseLongMatrix2D.this.elements[n22];
                                n22 += DenseLongMatrix2D.this.columnStride;
                            }
                            n += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2;
            for (int i = 0; i < this.rows; ++i) {
                long[] lArray2 = lArray[i];
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    lArray2[j] = this.elements[n7];
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return lArray;
    }

    public LongMatrix1D vectorize() {
        DenseLongMatrix1D denseLongMatrix1D = new DenseLongMatrix1D((int)this.size());
        final int n = (int)this.index(0, 0);
        final int n2 = (int)denseLongMatrix1D.index(0);
        final int n3 = denseLongMatrix1D.stride();
        final long[] lArray = denseLongMatrix1D.elements();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n4 = Math.min(n4, this.columns);
            Future[] futureArray = new Future[n4];
            int n5 = this.columns / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? this.columns : n6 + n5;
                final int n8 = i * n5 * this.rows;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = 0;
                        int n22 = n2 + n8 * n3;
                        for (int i = n6; i < n7; ++i) {
                            n4 = n + i * DenseLongMatrix2D.this.columnStride;
                            for (int j = 0; j < DenseLongMatrix2D.this.rows; ++j) {
                                lArray[n22] = DenseLongMatrix2D.this.elements[n4];
                                n4 += DenseLongMatrix2D.this.rowStride;
                                n22 += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n;
            int n10 = n2;
            for (int i = 0; i < this.columns; ++i) {
                n9 = n + i * this.columnStride;
                for (int j = 0; j < this.rows; ++j) {
                    lArray[n10] = this.elements[n9];
                    n9 += this.rowStride;
                    n10 += n3;
                }
            }
        }
        return denseLongMatrix1D;
    }

    public LongMatrix1D zMult(LongMatrix1D longMatrix1D, LongMatrix1D longMatrix1D2, final long l, final long l2, boolean bl) {
        if (bl) {
            return this.viewDice().zMult(longMatrix1D, longMatrix1D2, l, l2, false);
        }
        if (longMatrix1D2 == null) {
            longMatrix1D2 = new DenseLongMatrix1D(this.rows);
        }
        if (!(longMatrix1D instanceof DenseLongMatrix1D) || !(longMatrix1D2 instanceof DenseLongMatrix1D)) {
            return super.zMult(longMatrix1D, longMatrix1D2, l, l2, bl);
        }
        if ((long)this.columns != longMatrix1D.size() || (long)this.rows > longMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + longMatrix1D.toStringShort() + ", " + longMatrix1D2.toStringShort());
        }
        final long[] lArray = (long[])longMatrix1D.elements();
        final long[] lArray2 = (long[])longMatrix1D2.elements();
        if (this.elements == null || lArray == null || lArray2 == null) {
            throw new InternalError();
        }
        final int n = longMatrix1D.stride();
        final int n2 = longMatrix1D2.stride();
        final int n3 = (int)this.index(0, 0);
        final int n4 = (int)longMatrix1D.index(0);
        final int n5 = (int)longMatrix1D2.index(0);
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, this.rows);
            Future[] futureArray = new Future[n6];
            int n7 = this.rows / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.rows : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n3 + n8 * DenseLongMatrix2D.this.rowStride;
                        int n22 = n5 + n8 * n2;
                        for (int i = n8; i < n9; ++i) {
                            long l3 = 0L;
                            int n32 = n6;
                            int n42 = n4;
                            for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                l3 += DenseLongMatrix2D.this.elements[n32] * lArray[n42];
                                n32 += DenseLongMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            lArray2[n22] = l * l3 + l2 * lArray2[n22];
                            n6 += DenseLongMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n3;
            int n11 = n5;
            for (int i = 0; i < this.rows; ++i) {
                long l3 = 0L;
                int n12 = n10;
                int n13 = n4;
                for (int j = 0; j < this.columns; ++j) {
                    l3 += this.elements[n12] * lArray[n13];
                    n12 += this.columnStride;
                    n13 += n;
                }
                lArray2[n11] = l * l3 + l2 * lArray2[n11];
                n10 += this.rowStride;
                n11 += n2;
            }
        }
        return longMatrix1D2;
    }

    public LongMatrix2D zMult(LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2, final long l, final long l2, final boolean bl, final boolean bl2) {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = longMatrix2D.rows();
        int n5 = longMatrix2D.columns();
        int n6 = bl ? n3 : n2;
        int n7 = n = bl2 ? n4 : n5;
        if (longMatrix2D2 == null) {
            longMatrix2D2 = new DenseLongMatrix2D(n6, n);
        }
        if (bl) {
            return this.viewDice().zMult(longMatrix2D, longMatrix2D2, l, l2, false, bl2);
        }
        if (longMatrix2D instanceof SparseLongMatrix2D || longMatrix2D instanceof SparseRCLongMatrix2D) {
            if (longMatrix2D2 == null) {
                return longMatrix2D.zMult(this, null, l, l2, !bl2, true).viewDice();
            }
            longMatrix2D.zMult(this, longMatrix2D2.viewDice(), l, l2, !bl2, true);
            return longMatrix2D2;
        }
        if (bl2) {
            return this.zMult(longMatrix2D.viewDice(), longMatrix2D2, l, l2, bl, false);
        }
        if (!(longMatrix2D2 instanceof DenseLongMatrix2D)) {
            return super.zMult(longMatrix2D, longMatrix2D2, l, l2, bl, bl2);
        }
        if (longMatrix2D.rows() != n3) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + longMatrix2D.toStringShort());
        }
        if (longMatrix2D2.rows() != n2 || longMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + longMatrix2D.toStringShort() + ", " + longMatrix2D2.toStringShort());
        }
        if (this == longMatrix2D2 || longMatrix2D == longMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long l3 = 2L * (long)n2 * (long)n3 * (long)n5;
        int n8 = (int)Math.min(l3 / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean bl3 = n5 >= n8;
        int n9 = bl3 ? n5 : n2;
        n8 = Math.min(n9, n8);
        if (n8 < 2) {
            return this.zMultSequential(longMatrix2D, longMatrix2D2, l, l2, bl, bl2);
        }
        int n10 = n9 / n8;
        Future[] futureArray = new Future[n8];
        for (int i = 0; i < n8; ++i) {
            LongMatrix2D longMatrix2D3;
            LongMatrix2D longMatrix2D4;
            LongMatrix2D longMatrix2D5;
            int n11 = i * n10;
            if (i == n8 - 1) {
                n10 = n9 - n10 * i;
            }
            if (bl3) {
                longMatrix2D5 = this;
                longMatrix2D4 = longMatrix2D.viewPart(0, n11, n3, n10);
                longMatrix2D3 = longMatrix2D2.viewPart(0, n11, n2, n10);
            } else {
                longMatrix2D5 = this.viewPart(n11, 0, n10, n3);
                longMatrix2D4 = longMatrix2D;
                longMatrix2D3 = longMatrix2D2.viewPart(n11, 0, n10, n5);
            }
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    ((DenseLongMatrix2D)longMatrix2D5).zMultSequential(longMatrix2D4, longMatrix2D3, l, l2, bl, bl2);
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
        return longMatrix2D2;
    }

    public long zSum() {
        long l = 0L;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n4 = this.rows / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.rows : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = 0L;
                        int n3 = n + n5 * DenseLongMatrix2D.this.rowStride;
                        for (int i = n5; i < n6; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseLongMatrix2D.this.columns; ++j) {
                                l += DenseLongMatrix2D.this.elements[n2];
                                n2 += DenseLongMatrix2D.this.columnStride;
                            }
                            n3 += DenseLongMatrix2D.this.rowStride;
                        }
                        return l;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    l += ((Long)futureArray[n3].get()).longValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n7 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n8 = n7;
                for (int j = 0; j < this.columns; ++j) {
                    l += this.elements[n8];
                    n8 += this.columnStride;
                }
                n7 += this.rowStride;
            }
        }
        return l;
    }

    private LongMatrix2D zMultSequential(LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2, long l, long l2, boolean bl, boolean bl2) {
        if (bl) {
            return this.viewDice().zMult(longMatrix2D, longMatrix2D2, l, l2, false, bl2);
        }
        if (longMatrix2D instanceof SparseLongMatrix2D || longMatrix2D instanceof SparseRCLongMatrix2D || longMatrix2D instanceof SparseCCLongMatrix2D) {
            if (longMatrix2D2 == null) {
                return longMatrix2D.zMult(this, null, l, l2, !bl2, true).viewDice();
            }
            longMatrix2D.zMult(this, longMatrix2D2.viewDice(), l, l2, !bl2, true);
            return longMatrix2D2;
        }
        if (bl2) {
            return this.zMult(longMatrix2D.viewDice(), longMatrix2D2, l, l2, bl, false);
        }
        int n = this.rows;
        int n2 = this.columns;
        int n3 = longMatrix2D.columns();
        if (longMatrix2D2 == null) {
            longMatrix2D2 = new DenseLongMatrix2D(n, n3);
        }
        if (!(longMatrix2D instanceof DenseLongMatrix2D) || !(longMatrix2D2 instanceof DenseLongMatrix2D)) {
            return super.zMult(longMatrix2D, longMatrix2D2, l, l2, bl, bl2);
        }
        if (longMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + longMatrix2D.toStringShort());
        }
        if (longMatrix2D2.rows() != n || longMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + longMatrix2D.toStringShort() + ", " + longMatrix2D2.toStringShort());
        }
        if (this == longMatrix2D2 || longMatrix2D == longMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseLongMatrix2D denseLongMatrix2D = (DenseLongMatrix2D)longMatrix2D;
        DenseLongMatrix2D denseLongMatrix2D2 = (DenseLongMatrix2D)longMatrix2D2;
        long[] lArray = this.elements;
        long[] lArray2 = denseLongMatrix2D.elements;
        long[] lArray3 = denseLongMatrix2D2.elements;
        if (lArray == null || lArray2 == null || lArray3 == null) {
            throw new InternalError();
        }
        int n4 = this.columnStride;
        int n5 = denseLongMatrix2D.columnStride;
        int n6 = denseLongMatrix2D2.columnStride;
        int n7 = this.rowStride;
        int n8 = denseLongMatrix2D.rowStride;
        int n9 = denseLongMatrix2D2.rowStride;
        int n10 = (30000 - n2) / (n2 + 1);
        if (n10 <= 0) {
            n10 = 1;
        }
        int n11 = n / n10;
        int n12 = 0;
        if (n % n10 != 0) {
            ++n11;
        }
        while (--n11 >= 0) {
            int n13 = (int)denseLongMatrix2D.index(0, 0);
            int n14 = (int)this.index(n12, 0);
            int n15 = (int)denseLongMatrix2D2.index(n12, 0);
            n12 += n10;
            if (n11 == 0) {
                n10 += n - n12;
            }
            int n16 = n3;
            while (--n16 >= 0) {
                int n17 = n14;
                int n18 = n15;
                int n19 = n10;
                while (--n19 >= 0) {
                    int n20 = n17;
                    int n21 = n13;
                    long l3 = 0L;
                    n20 -= n4;
                    n21 -= n8;
                    int n22 = n2 % 4;
                    while (--n22 >= 0) {
                        l3 += lArray[n20 += n4] * lArray2[n21 += n8];
                    }
                    n22 = n2 / 4;
                    while (--n22 >= 0) {
                        int n23 = n20 + n4;
                        n20 = n23;
                        int n24 = n21 + n8;
                        n21 = n24;
                        int n25 = n20 + n4;
                        n20 = n25;
                        int n26 = n21 + n8;
                        n21 = n26;
                        n20 = n20 + n4;
                        n21 = n21 + n8;
                        l3 += lArray[n23] * lArray2[n24] + lArray[n25] * lArray2[n26] + lArray[n20] * lArray2[n21] + lArray[n20 += n4] * lArray2[n21 += n8];
                    }
                    lArray3[n18] = l * l3 + l2 * lArray3[n18];
                    n17 += n7;
                    n18 += n9;
                }
                n13 += n5;
                n15 += n6;
            }
        }
        return longMatrix2D2;
    }

    protected boolean haveSharedCellsRaw(LongMatrix2D longMatrix2D) {
        if (longMatrix2D instanceof SelectedDenseLongMatrix2D) {
            SelectedDenseLongMatrix2D selectedDenseLongMatrix2D = (SelectedDenseLongMatrix2D)longMatrix2D;
            return this.elements == selectedDenseLongMatrix2D.elements;
        }
        if (longMatrix2D instanceof DenseLongMatrix2D) {
            DenseLongMatrix2D denseLongMatrix2D = (DenseLongMatrix2D)longMatrix2D;
            return this.elements == denseLongMatrix2D.elements;
        }
        return false;
    }

    protected LongMatrix1D like1D(int n, int n2, int n3) {
        return new DenseLongMatrix1D(n, this.elements, n2, n3, true);
    }

    protected LongMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseLongMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

