/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.PersistentObject;
import cern.colt.list.tint.AbstractIntList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class IntFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final IntFactory1D dense = new IntFactory1D();
    public static final IntFactory1D sparse = new IntFactory1D();

    protected IntFactory1D() {
    }

    public IntMatrix1D append(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2) {
        IntMatrix1D intMatrix1D3 = this.make((int)(intMatrix1D.size() + intMatrix1D2.size()));
        intMatrix1D3.viewPart(0, (int)intMatrix1D.size()).assign(intMatrix1D);
        intMatrix1D3.viewPart((int)intMatrix1D.size(), (int)intMatrix1D2.size()).assign(intMatrix1D2);
        return intMatrix1D3;
    }

    public IntMatrix1D ascending(int n) {
        IntFunctions intFunctions = IntFunctions.intFunctions;
        return this.descending(n).assign(IntFunctions.chain(IntFunctions.neg, IntFunctions.minus(n)));
    }

    public IntMatrix1D descending(int n) {
        IntMatrix1D intMatrix1D = this.make(n);
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            intMatrix1D.setQuick(n3, n2++);
        }
        return intMatrix1D;
    }

    public IntMatrix1D make(int[] nArray) {
        if (this == sparse) {
            return new SparseIntMatrix1D(nArray);
        }
        return new DenseIntMatrix1D(nArray);
    }

    public IntMatrix1D make(IntMatrix1D[] intMatrix1DArray) {
        if (intMatrix1DArray.length == 0) {
            return this.make(0);
        }
        int n = 0;
        for (int i = 0; i < intMatrix1DArray.length; ++i) {
            n = (int)((long)n + intMatrix1DArray[i].size());
        }
        IntMatrix1D intMatrix1D = this.make(n);
        n = 0;
        for (int i = 0; i < intMatrix1DArray.length; ++i) {
            intMatrix1D.viewPart(n, (int)intMatrix1DArray[i].size()).assign(intMatrix1DArray[i]);
            n = (int)((long)n + intMatrix1DArray[i].size());
        }
        return intMatrix1D;
    }

    public IntMatrix1D make(int n) {
        if (this == sparse) {
            return new SparseIntMatrix1D(n);
        }
        return new DenseIntMatrix1D(n);
    }

    public IntMatrix1D make(int n, int n2) {
        return this.make(n).assign(n2);
    }

    public IntMatrix1D make(AbstractIntList abstractIntList) {
        int n = abstractIntList.size();
        IntMatrix1D intMatrix1D = this.make(n);
        int n2 = n;
        while (--n2 >= 0) {
            intMatrix1D.set(n2, abstractIntList.get(n2));
        }
        return intMatrix1D;
    }

    public IntMatrix1D random(int n) {
        return this.make(n).assign(IntFunctions.random());
    }

    public IntMatrix1D repeat(IntMatrix1D intMatrix1D, int n) {
        int n2 = (int)intMatrix1D.size();
        IntMatrix1D intMatrix1D2 = this.make(n * n2);
        int n3 = n;
        while (--n3 >= 0) {
            intMatrix1D2.viewPart(n2 * n3, n2).assign(intMatrix1D);
        }
        return intMatrix1D2;
    }

    public IntMatrix1D sample(int n, int n2, int n3) {
        double d = 1.0E-9;
        if ((double)n3 < 0.0 - d || (double)n3 > 1.0 + d) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > 1) {
            n3 = 1;
        }
        IntMatrix1D intMatrix1D = this.make(n);
        int n4 = Math.round(n * n3);
        if (n4 == 0) {
            return intMatrix1D;
        }
        DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = new DoubleRandomSamplingAssistant(n4, n, new DoubleMersenneTwister());
        int n5 = n;
        while (--n5 >= 0) {
            if (!doubleRandomSamplingAssistant.sampleNextElement()) continue;
            intMatrix1D.set(n5, n2);
        }
        return intMatrix1D;
    }

    public IntArrayList toList(IntMatrix1D intMatrix1D) {
        int n = (int)intMatrix1D.size();
        IntArrayList intArrayList = new IntArrayList(n);
        intArrayList.setSize(n);
        int n2 = n;
        while (--n2 >= 0) {
            intArrayList.set(n2, intMatrix1D.get(n2));
        }
        return intArrayList;
    }
}

