% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitValues.R
\name{weekIndex}
\alias{weekIndex}
\title{Generate an index of weeks}
\usage{
weekIndex(x)
}
\arguments{
\item{x}{A vector of dates}
}
\description{
Function to create a week index variable with weeks
determined as defined in ISO 8601.
If the week (starting on Monday) containing 1 January has four
or more days in the new year, then it is considered week 1.
Otherwise, it is the 53rd week of the previous year, and the
next week is week 1.
}
\examples{
# given a vector of dates
df <- data.frame(date = as.Date(c("2016-12-20","2016-12-27","2017-01-01","2017-01-07"),
format = "\%Y-\%m-\%d"))
# calculate the time period variable
df$period <- weekIndex(df$date)
df
}
