% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{CompareInteractive}
\alias{CompareInteractive}
\title{Interactive comparison of clustering results for a specific cluster or
method.}
\usage{
CompareInteractive(ListM, ListS, nrclusters = NULL, cols = NULL,
  fusionsLogM = FALSE, fusionsLogS = FALSE, weightclustM = FALSE,
  weightclustS = FALSE, namesM = NULL, namesS = NULL, marginsM = c(2,
  2.5, 2, 2.5), marginsS = c(8, 2.5, 2, 2.5), Interactive = TRUE, n = 1)
}
\arguments{
\item{ListM}{A list of the multiple source clustering or other methods to be
compared and from which a cluster or method will be identified. The first
element of the list will be used as the reference in
\code{ReorderToReference}.}

\item{ListS}{A list of the single source clustering or other methods the
identified result will be compared to. The first element of the list will be
used as the reference in \code{ReorderToReference}.}

\item{nrclusters}{The number of clusters to cut the dendrogram in. Default is NULL.}

\item{cols}{A character vector with the names of the colours.  Default is NULL.}

\item{fusionsLogM}{The fusionsLog parameter for the elements in ListM. To be
handed to \code{ReorderToReference}. Default is FALSE.}

\item{fusionsLogS}{The fusionslog parameter for the elements in ListS. To be
handed to \code{ReorderToReference}. Default is FALSE.}

\item{weightclustM}{The weightclust parameter for the elements in ListM. To
be handed to \code{ReorderToReference}. Default is FALSE.}

\item{weightclustS}{The weightclust parameter for the elements in ListS. To
be handed to \code{ReorderToReference}. Default is FALSE.}

\item{namesM}{Optional. Names of the multiple source clusterings to be used
as labels for the columns. Default is NULL.}

\item{namesS}{Optional. Names of the single source clusterings to be used as
labels for the columns. Default is NULL.}

\item{marginsM}{Optional. Margins to be used for the plot for the elements
is ListM after the identification. Default is c(2,2.5,2,2.5).}

\item{marginsS}{Optional. Margins to be used for the plot for the elements
is ListS after the identification. Default is c(8,2.5,2,2.5).}

\item{Interactive}{Optional. Do you want an interactive plot? Defaults to
TRUE, if not the function provides the same as \code{ComparePlot} for the
elements in ListM. Default is TRUE.}

\item{n}{The number of methods/clusters you want to identify. Default is 1.}
}
\value{
The returned value is a plot of the comparison of the elements of
ListM. On this plot multiple clusters and/or methods can be identified.
Click on a cluster of a specific method to see how that cluster of that
method compares to the elements in ListS. Click left next to a row to
identify a all cluster of a specific method. A new plotting window will
appear for every identification.
}
\description{
A visual comparison of all methods is handy to see which objects will
always cluster together independent of the applied methods. The function
\code{CompareInteractive} plots the comparison over the specified methods. A
cluster or method can than be identified by clicking and is plotted
separately against the single source or other specified methods.
}
\examples{

\dontrun{
data(fingerprintMat)
data(targetMat)
data(Colors1)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

L=list(fingerprintMat,targetMat)

MCF7_W=WeightedClust(List=L,type="data",distmeasure=c("tanimoto","tanimoto"),
normalize=c(FALSE,FALSE),method=c(NULL,NULL),weight=seq(1,0,-0.1),weightclust=0.5,
clust="agnes",linkage="ward",StopRange=FALSE)

ListM=list(MCF7_W)
namesM=c(seq(1.0,0.0,-0.1))

ListS=list(MCF7_F,MCF7_T)
namesS=c("FP","TP")

CompareInteractive(ListM,ListS,nrclusters=7,cols=Colors1,fusionsLogM=FALSE,
fusionsLogS=FALSE,weightclustM=FALSE,weightclustS=TRUE,namesM,namesS,
marginsM=c(2,2.5,2,2.5),marginsS=c(8,2.5,2,2.5),Interactive=TRUE,n=1)
}
}
