% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Functions.R
\name{fitJM}
\alias{fitJM}
\title{fitJM}
\usage{
fitJM(dat, responseVector, covariate = NULL, methodMultTest)
}
\arguments{
\item{dat}{Contains the gene expression data matrix for all the genes - can be a matrix or an expression set.}

\item{responseVector}{Vector containing the bio-activity data.}

\item{covariate}{Vector of 0's and 1's, containing data about the fingerprint feature.}

\item{methodMultTest}{Character string to specify the multiple testing method. Default is the BH-FDR method.}
}
\value{
A data frame, containing the results of the model, to be used later for plots or to identify the top genes.
}
\description{
The fitJM function fits the model for all the genes for a specific bio-activity vector and a particular fingerprint feature.
}
\details{
The default for the covariate parameter is NULL and if no covariate is specified it returns a data frame containing 5 variables, named as "Pearson","Spearman","p", "adj-p","logratio"
and the data frame is ordered based on the column "p" which is the p-value obtained from the Log-Ratio Test. If there is a covariate, then the output is a dataframe containing 13 variables for all the genes,named as
"adjPearson","adjSpearman","pPearson","Pearson", "Spearman", "pAdjR", "CovEffect1", "adjPeffect1", "CovEffect2", "adjPeffect2", "rawP1", "rawP2","logratio" and sorted based on "rawP1"  and "pPearson" which are
p-value corresponding to the effect of the fingerprint feature on the gene expression data as obtained from the t-table after fitting the model using gls and the p-value obtained from the Log-Ratio Test, respectively.
In the first case without any covariate it calls the nullcov function inside it, otherwise the non_nullcov function is called to do the analysis.
}
\examples{
\dontrun{
jmRes <- fitJM(dat=gene_eset,responseVector=activity,methodMultTest='fdr')
jmRes <- fitJM(dat=gene_eset,responseVector=activity,covariate = fp,methodMultTest='fdr')
}
}

