% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ivd2likert.R
\docType{methods}
\name{ivd2likert}
\alias{ivd2likert}
\alias{ivd2likert,IntervalData-method}
\alias{ivd2likert,IntervalList-method}
\alias{ivd2likert,IntervalMatrix-method}
\title{Convert interval-valued data responses into Likert-type responses}
\usage{
\S4method{ivd2likert}{IntervalData}(x, k = 7, minimum = 1, maximum = 7, theta = 1)

\S4method{ivd2likert}{IntervalList}(x, k = 7, minimum = 1, maximum = 7, theta = 1)

\S4method{ivd2likert}{IntervalMatrix}(x, k = 7, minimum = 1, maximum = 7, theta = 1)
}
\arguments{
\item{x}{an interval-valued data or a list or matrix of interval-valued data.}

\item{k}{a single positive integer value indicating the number of different Likert-type responses to be considered. By default, \code{k}=7.}

\item{minimum}{a single real number indicating the lower bound of the interval-valued scale used. By default, \code{minimum}=1.}

\item{maximum}{a single real number indicating the upper bound of the interval-valued scale used. By default, \code{maximum}=7.}

\item{theta}{a single positive numeric value. By default, \code{theta}=1.}
}
\value{
Returns the nearest Likert-type responses for the given interval-valued data following the minimum \eqn{\theta}-distance criterion.
}
\description{
Associate each interval-valued data in a questionnaire to a Likert-type response following the minimum \eqn{\theta}-distance criterion.
}
\details{
If a \eqn{k}-point Likert-type scale with reference interval \eqn{[l,u]} is considered, then the minimum distance criterion
consists in associating each interval-valued scale response with the real number in the set defined by \eqn{\{L_{1},L_{2},\ldots,L_{k}\},}
where \deqn{L_{i}=l+(i-1)\frac{u-l}{k-1},\qquad i=1,2,\ldots,k,} with the smallest \eqn{\theta}-distance to the given data. That is,
each interval-valued data \eqn{A} is associated with the real number \eqn{L(A)} such that
\deqn{L(A)=\arg\min_{L\in\{L_{1},L_{2},\ldots,L_{k}\}}d_{\theta}\left(A,\{L\}\right).}
If ties are produced, they are broken at random.
}
\examples{
## Convert to Likert-type response an interval-valued response
ivd2likert(IntervalData(3, 3.2), 11, 0, 10)

## Convert to Likert-type responses a list of interval-valued responses
ivd2likert(IntervalList(c(3, 8.7), c(3.2, 9)), 11, 0, 10)

## Convert to Likert-type response a matrix or dataframe of interval-valued responses
ivd2likert(IntervalMatrix(matrix(c(1, 1.5, 3.8, 4, 2.6, 3, 6, 7), 2, 4, byrow = TRUE)))

}
\seealso{
Other IntervalData-method: 
\code{\link{IntervalData-class}},
\code{\link{IntervalData}},
\code{\link{arithmetic}},
\code{\link{as.IntervalData}()},
\code{\link{distance}()},
\code{\link{ivd2vas}()},
\code{\link{plot}()},
\code{\link{show}()}

Other IntervalList-method: 
\code{\link{IntervalList-class}},
\code{\link{IntervalList}},
\code{\link{as.IntervalList}()},
\code{\link{cov}()},
\code{\link{ivd2vas}()},
\code{\link{mean}()},
\code{\link{plot}()},
\code{\link{sum}()},
\code{\link{var}()}

Other IntervalMatrix-method: 
\code{\link{IntervalMatrix-class}},
\code{\link{IntervalMatrix}},
\code{\link{apply}()},
\code{\link{ivd2vas}()},
\code{\link{show}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalData-method}
\concept{IntervalList-method}
\concept{IntervalMatrix-method}
