% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Irescale.R
\name{iCorrection}
\alias{iCorrection}
\title{Scaling process for Moran's I.}
\usage{
iCorrection(I, vI, statsVI, scalingUpTo = "Quantile")
}
\arguments{
\item{I}{Moran's I, It could be computed using calculateMoranI function.}

\item{vI}{the vector obtained by resamplingI.}

\item{statsVI}{the statistic vector obtained from summaryVector.}

\item{scalingUpTo}{the rescaling could be done up to the 0.01\% and 99.9\% quantile or max and min values. The two possible options are: "MaxMin", or "Quantile". The default value for this parameter is Quantile.}
}
\value{
rescaled I
}
\description{
\code{iCorrection} . consists in centering the I value (I-median) and scaling by the difference between the median and 1st or 99th quantile. The correction is according to the following equation:
\deqn{
I = \left\{
\begin{array}{lr}
\frac{(I-median)}{(median - Q1)}& I < median\\
\frac{(I-median)}{(Q99-median)}& I>median\\
\end{array}\right\}
}
}
\examples{
inputFileName<-system.file("testdata", "chen.csv", package="Irescale")
input<-loadFile(inputFileName)
distM<-calculateEuclideanDistance(input$data)
I<-calculateMoranI(distM = distM,varOfInterest = input$varOfInterest)
vI<-resamplingI(1000,distM, input$varOfInterest)
statsVI<-summaryVector(vI)
corrections<-iCorrection(I,vI,scalingUpTo="Quantile")
}
