% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordia.R
\name{concordia}
\alias{concordia}
\title{Concordia diagram}
\usage{
concordia(x, limits = NULL, alpha = 0.05, wetherill = TRUE,
  show.numbers = FALSE, ellipse.col = rgb(0, 1, 0, 0.5),
  concordia.col = "darksalmon", exterr = TRUE, show.age = 0, sigdig = 2,
  common.Pb = 0)
}
\arguments{
\item{x}{an object of class \code{UPb}}

\item{limits}{age limits of the concordia line}

\item{alpha}{confidence cutoff for the error ellipses}

\item{wetherill}{logical flag (\code{FALSE} for Tera-Wasserburg)}

\item{show.numbers}{logical flag (\code{TRUE} to show grain numbers)}

\item{ellipse.col}{background colour of the error ellipses}

\item{concordia.col}{colour of the concordia line}

\item{exterr}{show decay constant uncertainty?}

\item{show.age}{one of either:

\code{0}: just plot the data but don't calculate the age

\code{1}: calculate the concordia age

\code{2}: fit a discordia line}

\item{sigdig}{number of significant digits for the
concordia/discordia age}

\item{common.Pb}{apply a common lead correction using one of three
    methods:

\code{1}: use the isochron intercept as the initial Pb-composition

\code{2}: use the Stacey-Kramer two-stage model to infer the initial
Pb-composition

\code{3}: use the Pb-composition stored in
\code{settings('iratio','Pb206Pb204')} and
\code{settings('iratio','Pb207Pb204')}}
}
\description{
Plots U-Pb data on Wetherill and Tera-Wasserburg concordia
diagrams, calculate concordia ages and compositions, evaluates the
equivalence of multiple
(\eqn{^{206}}Pb/\eqn{^{238}}U-\eqn{^{207}}Pb/\eqn{^{235}}U or
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U)
compositions, computes the weighted mean isotopic composition and
the corresponding concordia age using the method of maximum
likelihood, computes the MSWD of equivalence and concordance and
their respective Chi-squared p-values. Performs linear regression
and computes the upper and lower intercept ages (for Wetherill) or
the lower intercept age and the \eqn{^{207}}Pb/\eqn{^{206}}Pb
intercept (for Tera-Wasserburg), taking into account error
correlations and decay constant uncertainties.
}
\examples{
data(examples) 
concordia(examples$UPb)
}
\references{
Ludwig, K.R., 1998. On the treatment of concordant
    uranium-lead ages. Geochimica et Cosmochimica Acta, 62(4),
    pp.665-676.
}
