% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.data}
\alias{read.data}
\alias{read.data.default}
\alias{read.data.data.frame}
\alias{read.data.matrix}
\title{Read geochronology data}
\usage{
read.data(x, ...)

\method{read.data}{default}(
  x,
  method = "U-Pb",
  format = 1,
  ierr = 1,
  d = diseq(),
  Th02 = c(0, 0),
  Th02U48 = c(0, 0, 1e+06, 0, 0, 0, 0, 0, 0),
  ...
)

\method{read.data}{data.frame}(
  x,
  method = "U-Pb",
  format = 1,
  ierr = 1,
  d = diseq(),
  Th02 = c(0, 0),
  Th02U48 = c(0, 0, 1e+06, 0, 0, 0, 0, 0, 0),
  ...
)

\method{read.data}{matrix}(
  x,
  method = "U-Pb",
  format = 1,
  ierr = 1,
  d = diseq(),
  Th02 = c(0, 0),
  Th02U48 = c(0, 0, 1e+06, 0, 0, 0, 0, 0, 0),
  ...
)
}
\arguments{
\item{x}{either a file name (\code{.csv} format) OR a matrix}

\item{...}{optional arguments to the \code{read.csv} function}

\item{method}{one of \code{'U-Pb'}, \code{'Pb-Pb'}, \code{'Th-Pb'},
\code{'Ar-Ar'}, \code{'K-Ca'}, \code{'detritals'},
\code{'Rb-Sr'}, \code{'Sm-Nd'}, \code{'Re-Os'}, \code{'Th-U'},
\code{'U-Th-He'}, \code{'fissiontracks'} or \code{'other'}}

\item{format}{formatting option, depends on the value of
    \code{method}.

if \code{method='U-Pb'}, then \code{format} is one of either:

\enumerate{
\item{\code{07/35, err[07/35],} \code{06/38, err[06/38], rho}} 
\item{\code{38/06, err[38/06],}\code{07/06, err[07/06] (, rho)}}
\item{\code{X=07/35, err[X],} \code{Y=06/38, err[Y],}
      \code{Z=07/06, err[Z]} \code{(, rho[X,Y]) (, rho[Y,Z])}} 
\item{\code{X=07/35, err[X], Y=06/38, err[Y], Z=04/38, }
      \code{rho[X,Y], rho[X,Z], rho[Y,Z]}} 
\item{\code{X=38/06, err[X]}, \code{Y=07/06, err[Y]},
      \code{Z=04/06, err[Z] (}, \code{rho[X,Y], rho[X,Z], rho[Y,Z])}}
\item{\code{07/35, err[07/35]}, \code{06/38, err[06/38]},
      \code{04/38, err[04/38]}, \code{07/06, err[07/06]},
      \code{04/07, err[04/07]}, \code{04/06, err[04/06]}}
\item{\code{W=07/35, err[W]}, \code{X=06/38, err[X]},
      \code{Y=08/32, err[Y]}, and \code{Z=32/38, err[Z]},
      \code{rho[W,X], rho[W,Y]}, \code{rho[W,Z], rho[X,Y]},
      \code{rho[X,Z], rho[Y,Z]}}
\item{\code{W=38/06, err[W]}, \code{X=07/06, err[X]},
      \code{Y=08/06, err[Y]}, and \code{Z=32/38, (err[Z]},
      \code{rho[W,X], rho[W,Y]}, \code{rho[W,Z], rho[X,Y]},
      \code{rho[X,Z], rho[Y,Z])}}
}

where optional columns are marked in round brackets

if \code{method='Pb-Pb'}, then \code{format} is one of either:

\enumerate{
\item{\code{6/4, err[6/4], 7/4, err[7/4], rho}}
\item{\code{4/6, err[4/6], 7/6, err[7/6], rho}}
\item{\code{6/4, err[6/4], 7/4, err[7/4], 6/7, err[6/7]}}
}

if \code{method='Th-Pb'}, then \code{format} is one of either:

\enumerate{
\item{\code{32/04, err[32/04], 08/04, err[08/04], rho}}
\item{\code{32/08, err[32/08], 04/08, err[08/04], rho}}
\item{\code{32/04, err[32/04], 08/04, }
      \code{err[08/04], 32/08, err[32/08]}}
}

if \code{method='Ar-Ar'}, then \code{format} is one of either:

\enumerate{
\item{\code{9/6, err[9/6], 0/6, err[0/6], rho (, 39)}}
\item{\code{6/0, err[6/0], 9/0, err[9/0] (, rho) (, 39)}}
\item{\code{9/0, err[9/0], 6/0, err[6/0], 9/6, err[9/6] (, 39)}}
}

if \code{method='K-Ca'}, then \code{format} is one of either:

\enumerate{
\item{\code{K40/Ca44, err[K40/Ca44], Ca40/Ca44, err[Ca40/Ca44], rho}}
\item{\code{K40/Ca40, err[K40/Ca40], Ca44/Ca40, err[Ca44/Ca40], rho}}
\item{\code{K40/Ca44, err[K40/Ca44], Ca40/Ca44, }
      \code{err[Ca40/Ca44], K40/Ca40, err[K40/Ca40]}}
}

if \code{method='Rb-Sr'}, then \code{format} is one of either:

\enumerate{
\item{\code{Rb87/Sr86, err[Rb87/Sr86], Sr87/Sr86, err[Sr87/Sr86] (, rho)}}
\item{\code{Rb87/Sr87, err[Rb87/Sr87], Sr86/Sr87, err[Sr86/Sr87] (, rho)}}
\item{\code{Rb, err[Rb], Sr, err[Sr], Sr87/Sr86, err[Sr87/Sr86]}}
}

where \code{Rb} and \code{Sr} are in ppm

if \code{method='Sm-Nd'}, then \code{format} is one of either:

\enumerate{
\item{\code{Sm147/Nd144, err[Sm147/Nd144], Nd143/Nd144, err[Nd143/Nd144] (, rho)}}
\item{\code{Sm147/Nd143, err[Sm147/Nd143], Nd144/Nd143, err[Nd144/Nd143] (, rho)}}
\item{\code{Sm, err[Sm], Nd, err[Nd], Nd143/Nd144, err[Nd143/Nd144]}}
}

where \code{Sm} and \code{Nd} are in ppm

if \code{method='Re-Os'}, then \code{format} is one of either:

\enumerate{
\item{\code{Re187/Os188, err[Re187/Os188], Os187/Os188, err[Os187/Os188] (, rho)}}
\item{\code{Re187/Os187, err[Re187/Os187], Os188/Os187, err[Os188/Os187] (, rho)}}
\item{\code{Re, err[Re], Os, err[Os], Os187/Os188, err[Os187/Os188]}}
}

where \code{Re} and \code{Os} are in ppm

if \code{method='Lu-Hf'}, then \code{format} is one of either:

\enumerate{
\item{\code{Lu176/Hf177, err[Lu176/Hf177], Hf176/Hf177, err[Hf176/Hf177] (, rho)}}
\item{\code{Lu176/Hf176, err[Lu176/Hf176], Hf177/Hf176, err[Hf177/Hf176] (, rho)}}
\item{\code{Lu, err[Lu], Hf, err[Hf], Hf176/Hf177, err[Hf176/Hf177]}}
}

where \code{Lu} and \code{Hf} are in ppm

if \code{method='Th-U'}, then \code{format} is one of either:

\enumerate{
\item{\code{X=8/2, err[X], Y=4/2, err[Y], Z=0/2, err[Z],}\cr
\code{rho[X,Y], rho[X,Z], rho[Y,Z]}}
\item{\code{X=2/8, err[X], Y=4/8, err[Y], Z=0/8, err[Z],}\cr
\code{ rho[X,Y], rho[X,Z], rho[Y,Z]}}
\item{\code{X=8/2, err[X], Y=0/2, err[Y], rho[X,Y]}}
\item{\code{X=2/8, err[X], Y=0/8, err[Y], rho[X,Y]}}
}

where all values are activity ratios

if \code{method='fissiontracks'}, then \code{format} is one of
either:

\enumerate{
\item{the External Detector Method (EDM), which requires a
\eqn{\zeta}-calibration constant and its uncertainty, the induced
track density in a dosimeter glass, and a table with the
spontaneous and induced track densities.}

\item{LA-ICP-MS-based fission track data using the
\eqn{\zeta}-calibration method, which requires a 'session
\eqn{\zeta}' and its uncertainty and a table with the number of
spontaneous tracks, the area over which these were counted and one
or more U/Ca- or U-concentration measurements and their analytical
uncertainties.}

\item{LA-ICP-MS-based fission track data using the 'absolute
dating' method, which only requires a table with the the number of
spontaneous tracks, the area over which these were counted and one
or more U/Ca-ratios or U-concentration measurements (in ppm) and
their analytical uncertainties.}  }

if \code{method='other'}, \code{x} is read as a table, unless
\code{format} is one of either:

\describe{
\item{\code{radial} or \code{average}:}{\code{X, err[X]}}
\item{\code{regression}:}{\code{X, err[X], Y, err[Y], rho} \cr
      OR \code{X/Z, err[X/Z], Y/Z, err[Y/Z], X/Y, err[X/Y]}}
\item{\code{spectrum}:}{\code{f, X, err[X]}} 
}}

\item{ierr}{indicates whether the analytical uncertainties are
    reported as: 

\code{1}: 1\eqn{\sigma} absolute uncertainties.

\code{2}: 2\eqn{\sigma} absolute uncertainties.

\code{3}: 1\eqn{\sigma} relative uncertainties (\%).

\code{4}: 2\eqn{\sigma} relative uncertainties (\%).}

\item{d}{an object of class \code{\link{diseq}}.}

\item{Th02}{2-element vector with the assumed initial
\eqn{^{230}}Th/\eqn{^{232}}Th-ratio of the detritus and its
standard error. Only used if \code{isochron=FALSE} and
\code{detritus=2}}

\item{Th02U48}{9-element vector with the measured composition of
the detritus, containing \code{X=0/8}, \code{sX}, \code{Y=2/8},
\code{sY}, \code{Z=4/8}, \code{sZ}, \code{rXY}, \code{rXZ},
\code{rYZ}.}
}
\value{
\itemize{

\item If \code{method="U-Pb"}: an object of class \code{UPb}, i.e. a list
inheriting the input arguments \code{x}, \code{format} and \code{d}.

\item If \code{method="ArAr"}: and object of class \code{ArAr}, i.e. a
three item list containing the following items:

\code{x}: a matrix containing the isotopic measurements

\code{J}: a two-element vector with the J-factor and its
uncertainty, extracted from the input file.

\code{format}: same as the input argument

\item If \code{method="Pb-Pb"}, \code{method="Th-Pb"},
\code{"K-Ca"}, \code{"Rb-Sr"}, \code{"Sm-Nd"}, \code{"Lu-Hf"}, or
\code{"Re-Os"}: objects of classes \code{PbPb}, \code{KCa},
\code{RbSr}, \code{SmNd}, \code{LuHf}, or \code{ReOs},
respectively; i.e. a list inheriting the input arguments \code{x}
and \code{format}.

\item If \code{method="UThHe"}: an object of class \code{UThHe},
i.e. a matrix with the contents of \code{x}.

\item If \code{method="fissiontracks"}: an object of class
\code{fissiontracks}, i.e. a list containing the following items:

\code{format}: same as the input argument

\code{x}: a matrix of spontaneous and induced fission track counts
(only returned if \code{format=1})

\code{rhoD}: the track density of the dosimeter glass, extracted
from the input data (only returned if \code{format=1})

\code{zeta}: the zeta calibration constant extracted from the input
data (only returned if \code{format<3})

\code{Ns} a list containing the spontaneous fission track counts
(only returned if \code{format>1})

\code{U}: a list of lists containing the U-concentration or
U/Ca-ratio measurements for each of the analysed grains (only
returned if \code{format>1})

\code{sU}: a list of lists containing the standard errors of the
U-concentration or U/Ca-ratio measurements for each of the analysed
grains (only returned if \code{format>1})

\code{spotSize}: the laser ablation spot size (only returned if
\code{format>1})

\item If \code{method="detritals"}: an object of class
\code{detritals}, i.e. a list of named vectors, one for each
detrital sample.

}
}
\description{
Cast a \code{.csv} file or a matrix into one of \code{IsoplotR}'s
data classes
}
\details{
IsoplotR provides the following example input files:

\itemize{
\item{U-Pb: \code{UPb1.csv}, \code{UPb2.csv}, \code{UPb3.csv},
\code{UPb4.csv}, \code{UPb5.csv}, \code{UPb6.csv},
\code{UPb7.csv}, \code{UPb8.csv}}
\item{Pb-Pb: \code{PbPb1.csv}, \code{PbPb2.csv}, \code{PbPb3.csv}}
\item{Th-Pb: \code{ThPb1.csv}, \code{ThPb2.csv}, \code{ThPb3.csv}}
\item{Ar-Ar: \code{ArAr1.csv}, \code{ArAr2.csv}, \code{ArAr3.csv}}
\item{K-Ca: \code{KCa1.csv}, \code{KCa2.csv}, \code{KCa3.csv}}
\item{Re-Os: \code{ReOs1.csv}, \code{ReOs2.csv}, \code{ReOs3.csv}}
\item{Sm-Nd: \code{SmNd1.csv}, \code{SmNd2.csv}, \code{SmNd3.csv}}
\item{Rb-Sr: \code{RbSr1.csv}, \code{RbSr2.csv}, \code{RbSr3.csv}}
\item{Lu-Hf: \code{LuHf1.csv}, \code{LuHf2.csv}, \code{LuHf3.csv}}
\item{Th-U: \code{ThU1.csv}, \code{ThU2.csv}, \code{ThU3.csv}
\code{ThU4.csv}}
\item{fissiontracks: \code{FT1.csv}, \code{FT2.csv},
\code{FT3.csv}}
\item{U-Th-He: \code{UThHe.csv}, \code{UThSmHe.csv}}
\item{detritals: \code{DZ.csv}}
\item{other: \code{LudwigMixture.csv}, \code{LudwigMean.csv},
\code{LudwigKDE.csv}, \code{LudwigSpectrum.csv}}
}

The contents of these files can be viewed using the
\code{system.file(...)} function. For example, to read the
\code{ArAr1.csv} file:

\code{fname <- system.file('ArAr1.csv',package='IsoplotR')}

\code{ArAr <- read.data(fname,method='Ar-Ar',format=1)}
}
\examples{

f1 <- system.file("UPb1.csv",package="IsoplotR")
file.show(f1) # inspect the contents of 'UPb1.csv'
d1 <- read.data(f1,method="U-Pb",format=1)
concordia(d1)

f2 <- system.file("ArAr1.csv",package="IsoplotR")
d2 <- read.data(f2,method="Ar-Ar",format=1)
agespectrum(d2)

f3 <- system.file("ReOs1.csv",package="IsoplotR")
d3 <- read.data(f3,method="Re-Os",format=1)
isochron(d2)

f4 <- system.file("FT1.csv",package="IsoplotR")
d4 <- read.data(f4,method="fissiontracks",format=1)
radialplot(d4)

f5 <- system.file("UThSmHe.csv",package="IsoplotR")
d5 <- read.data(f5,method="U-Th-He")
helioplot(d5)

f6 <- system.file("ThU2.csv",package="IsoplotR")
d6 <- read.data(f6,method="Th-U",format=2)
evolution(d6)

#  one detrital zircon U-Pb file (detritals.csv)
f7 <- system.file("DZ.csv",package="IsoplotR")
d7 <- read.data(f7,method="detritals")
kde(d7)

#  four 'other' files (LudwigMixture.csv, LudwigSpectrum.csv,
#  LudwigMean.csv, LudwigKDE.csv)
f8 <- system.file("LudwigMixture.csv",package="IsoplotR")
d8 <- read.data(f8,method="other")
radialplot(d8)

}
\seealso{
\code{\link{examples}}, \code{\link{settings}}
}
