/*
 * Decompiled with CFR 0.152.
 */
package j4r.multiprocess;

import j4r.app.AbstractGenericTask;
import j4r.multiprocess.JavaProcess;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;

public class JavaProcessWrapper
extends AbstractGenericTask
implements PropertyChangeListener {
    private static final long serialVersionUID = 20120218L;
    private JavaProcess internalProcess;
    private boolean atLeastOneMessageReceived;

    public JavaProcessWrapper(String taskName, List<String> commands, File workingDirectory) {
        this.setName(taskName);
        this.internalProcess = new JavaProcess(commands, workingDirectory);
        this.internalProcess.redirectOutputStream(false);
        this.internalProcess.addPropertyChangeListener(this);
    }

    public JavaProcess getInternalProcess() {
        return this.internalProcess;
    }

    @Override
    public void cancel() {
        this.internalProcess.cancel(true);
        super.cancel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        String propertyName;
        if (arg0.getSource().equals(this.internalProcess) && (propertyName = arg0.getPropertyName()).equals("MessageReceived")) {
            if (!this.atLeastOneMessageReceived) {
                this.atLeastOneMessageReceived = true;
            }
            System.out.println((String)arg0.getNewValue());
        }
    }

    @Override
    public void doThisJob() throws Exception {
        this.internalProcess.execute();
        int output = -1;
        try {
            output = this.internalProcess.get();
        }
        catch (Exception e) {
            if (this.hasBeenCancelled()) {
                output = 0;
            }
            throw e;
        }
        if (output == 0 && this.atLeastOneMessageReceived) {
            return;
        }
        throw new Exception("Process exited with value " + output);
    }
}

