% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_ngram.R
\name{ngram}
\alias{ngram}
\title{ngram}
\usage{
ngram(
  x,
  pattern,
  ngram = c(-3, 3),
  tolower = FALSE,
  split = FALSE,
  exact = FALSE
)
}
\arguments{
\item{x}{vector of text strings to process.}

\item{pattern}{a search term pattern to extract the ngram bag of words.}

\item{ngram}{a vector of length=2 that defines the number of words to extract from left and right side of pattern match.}

\item{tolower}{Logical. If TRUE converts text and pattern to lower case.}

\item{split}{Logical. If TRUE splits text input at "[.,;:] " before processing. Note: You may consider other text splits before.}

\item{exact}{Logical. If TRUE only exact word matches will be proceses}
}
\value{
Character. Vector with +-n words of search pattern.
}
\description{
Extracts ngram bag of words around words that match a search pattern. 
Note: If an input contains the search pattern twice, only the ngram bag of words of the last hit is detected. Consider individual text splitting with text2sentences() or strsplit2() before applying ngram().
}
\examples{
text<-"One hundred twenty-eight students participated in our Study, 
that was administred in thirteen clinics."
ngram(text,pattern="study",ngram=c(-1,2))
}
