% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{tracks}
\alias{tracks}
\title{Create a set of tracks for a custom JBrowse 2 view}
\usage{
tracks(...)
}
\arguments{
\item{...}{The tracks to be added to the JBrowse 2 view}
}
\value{
a character vector of stringified JSON configuration for
all tracks to add to the browser
}
\description{
Accepts any number of tracks, returns the configuration
string necessary to load these tracks into your JBrowse
view.
}
\examples{
# create an assembly configuration and alignments track
assembly <- assembly("https://jbrowse.org/genomes/hg19/fasta/hg19.fa.gz", bgzip = TRUE)
alignments <- track_alignments("alignments.bam", assembly)

# create a tracks configuration with the alignments track
tracks(alignments)
}
