/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.DataTable;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.ibase.SVarSet;

public class TxtTableLoader
extends JFrame {
    private static final long serialVersionUID = -1441684043207305950L;
    private String file;
    private JPanel jPanel1;
    private JLabel quoteLabel;
    private JCheckBox header;
    private JLabel sepsBoxLabel;
    private JComboBox quoteBox;
    private JComboBox sepsBox;
    private JTable dataTable;
    private JPanel tablePanel;
    private JButton cancel;
    private JButton load;
    private JPanel buttonPanel;
    private JScrollPane tablePane;
    private final String[] quotes = new String[]{"", "\\\"", "\\'"};
    private final String[] seps = new String[]{"\\t", "", ",", ";", "|"};
    private String previewName = "...temp_data12121...";
    private String dataName = null;

    public TxtTableLoader(String string, String string2) {
        this.file = string;
        this.dataName = string2;
        this.initGUI();
        this.checkFile();
        this.loadPreview();
    }

    public static void run(String string, String string2) {
        final String string3 = string;
        final String string4 = string2;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TxtTableLoader txtTableLoader = new TxtTableLoader(string3, string4);
                txtTableLoader.setLocationRelativeTo(null);
                txtTableLoader.setVisible(true);
            }
        });
    }

    public void setFile(String string) {
        this.file = string;
    }

    public TxtTableLoader() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Read Delimited File");
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout(anchorLayout);
            this.setDefaultCloseOperation(2);
            this.jPanel1 = new JPanel();
            AnchorLayout anchorLayout2 = new AnchorLayout();
            this.getContentPane().add((Component)this.jPanel1, new AnchorConstraint(1, 963, 1001, 39, 1, 1, 1, 1));
            this.jPanel1.setPreferredSize(new Dimension(414, 333));
            this.jPanel1.setLayout(anchorLayout2);
            this.tablePanel = new JPanel();
            Serializable serializable = new BorderLayout();
            this.tablePanel.setLayout((LayoutManager)((Object)serializable));
            this.jPanel1.add((Component)this.tablePanel, new AnchorConstraint(328, 1001, 863, 1, 1, 1, 1, 1));
            this.tablePanel.setPreferredSize(new Dimension(356, 178));
            DefaultTableModel defaultTableModel = new DefaultTableModel(new String[][]{{"Select File to load Data"}}, new String[]{"Column 1"});
            this.dataTable = new JTable();
            this.dataTable.setModel(defaultTableModel);
            this.tablePane = new JScrollPane(this.dataTable);
            this.tablePanel.add(this.tablePane);
            this.tablePane.setPreferredSize(new Dimension(356, 167));
            this.dataTable.setAutoResizeMode(0);
            this.header = new JCheckBox();
            this.jPanel1.add((Component)this.header, new AnchorConstraint(211, 1001, 265, 763, 1, 1, 1, 1));
            this.header.setText("Header");
            this.header.setPreferredSize(new Dimension(91, 18));
            this.header.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TxtTableLoader.this.headerActionPerformed(actionEvent);
                }
            });
            this.quoteLabel = new JLabel();
            this.jPanel1.add((Component)this.quoteLabel, new AnchorConstraint(148, 894, 190, 350, 1, 1, 1, 1));
            this.quoteLabel.setText("Quote");
            this.quoteLabel.setPreferredSize(new Dimension(179, 14));
            this.sepsBoxLabel = new JLabel();
            this.jPanel1.add((Component)this.sepsBoxLabel, new AnchorConstraint(148, 426, 190, 1, 1, 1, 1, 1));
            this.sepsBoxLabel.setText("Record Seperator");
            this.sepsBoxLabel.setPreferredSize(new Dimension(163, 14));
            serializable = new DefaultComboBoxModel<String>(new String[]{"None", "Double Quote (\")", "Single Quote (')"});
            this.quoteBox = new JComboBox();
            this.jPanel1.add((Component)this.quoteBox, new AnchorConstraint(208, 750, 271, 350, 1, 1, 1, 1));
            this.quoteBox.setModel(serializable);
            this.quoteBox.setPreferredSize(new Dimension(120, 21));
            this.quoteBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TxtTableLoader.this.quoteBoxActionPerformed(actionEvent);
                }
            });
            serializable = new DefaultComboBoxModel<String>(new String[]{"Tab (\\t)", "Space (\\w)", "Comma (,)", ";", "|"});
            this.sepsBox = new JComboBox();
            this.sepsBox.setPreferredSize(new Dimension(120, 21));
            this.jPanel1.add((Component)this.sepsBox, new AnchorConstraint(208, 300, 271, 1, 1, 1, 1, 1));
            this.sepsBox.setModel(serializable);
            this.sepsBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TxtTableLoader.this.sepsBoxActionPerformed(actionEvent);
                }
            });
            this.buttonPanel = new JPanel();
            serializable = new FlowLayout();
            ((FlowLayout)serializable).setAlignment(2);
            this.jPanel1.add((Component)this.buttonPanel, new AnchorConstraint(881, 998, 1001, -15, 1, 1, 0, 1));
            this.buttonPanel.setPreferredSize(new Dimension(361, 40));
            this.buttonPanel.setLayout((LayoutManager)((Object)serializable));
            this.cancel = new JButton();
            this.buttonPanel.add(this.cancel);
            this.cancel.setText("Cancel");
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TxtTableLoader.this.cancelActionPerformed(actionEvent);
                }
            });
            this.load = new JButton();
            this.buttonPanel.add(this.load);
            this.load.setText("Load");
            this.load.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TxtTableLoader.this.loadActionPerformed(actionEvent);
                }
            });
            this.pack();
            this.setSize(425, 368);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    private void checkFile() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            String string = null;
            String string2 = null;
            if (bufferedReader.ready()) {
                string = bufferedReader.readLine();
            }
            if (bufferedReader.ready()) {
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            if (string2 != null) {
                int n = string2.indexOf("\"");
                if (n > -1 && string2.indexOf("\"", n + 1) > -1) {
                    this.quoteBox.setSelectedItem("Double Quote (\")");
                } else {
                    n = string2.indexOf("'");
                    if (n > -1 && string2.indexOf("'", n + 1) > -1) {
                        this.quoteBox.setSelectedItem("Single Quote (')");
                    } else {
                        this.quoteBox.setSelectedItem("None");
                    }
                }
                this.sepsBox.setSelectedItem("Space (\\w)");
                n = string2.indexOf("\t");
                if (n > -1 && string2.indexOf("\t", n + 1) > -1) {
                    this.sepsBox.setSelectedItem("Tab (\\t)");
                }
                if ((n = string2.indexOf(";")) > -1 && string2.indexOf(";", n + 1) > -1) {
                    this.sepsBox.setSelectedItem(";");
                }
                if ((n = string2.indexOf(",")) > -1 && string2.indexOf(",", n + 1) > -1) {
                    this.sepsBox.setSelectedItem("Comma (,)");
                }
                if ((n = string2.indexOf("|")) > -1 && string2.indexOf("|", n + 1) > -1) {
                    this.sepsBox.setSelectedItem("|");
                }
            }
            if (string != null && string2 != null) {
                String string3 = this.seps[this.sepsBox.getSelectedIndex()];
                string3 = string3 == "\\t" ? "\t" : string3;
                int n = 0;
                int n2 = 0;
                if (string3.length() == 0) {
                    n = new StringTokenizer(string).countTokens();
                    n2 = new StringTokenizer(string2).countTokens();
                } else {
                    int n3 = -1;
                    while ((n3 = string.trim().indexOf(string3, n3 + 1)) > -1) {
                        ++n;
                    }
                    n3 = -1;
                    while ((n3 = string2.trim().indexOf(string3, n3 + 1)) > -1) {
                        ++n2;
                    }
                }
                if (n + 1 == n2 || n == n2 && string.matches("^[a-zA-Z\"].*")) {
                    this.header.setSelected(true);
                } else {
                    this.header.setSelected(false);
                }
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void loadInR(String string, boolean bl) {
        String string2 = this.file.toString();
        String string3 = this.sepsBox.getSelectedIndex() >= this.seps.length ? this.sepsBox.getSelectedItem().toString() : this.seps[this.sepsBox.getSelectedIndex()];
        String string4 = this.quoteBox.getSelectedIndex() >= this.quotes.length ? this.quoteBox.getSelectedItem().toString() : this.quotes[this.quoteBox.getSelectedIndex()];
        String string5 = (bl ? "try(" : "") + string + " <- read.table(\"" + string2 + "\",header=" + (this.header.isSelected() ? "T" : "F") + ",sep=\"" + string3 + "\"" + (bl ? ",nrows=10" : "") + ",quote=\"" + string4 + "\")" + (bl ? ",silent=TRUE)" : "");
        if (bl) {
            try {
                JGR.eval(string5);
            }
            catch (REngineException rEngineException) {
                new ErrorMsg(rEngineException);
            }
            catch (REXPMismatchException rEXPMismatchException) {
                new ErrorMsg(rEXPMismatchException);
            }
        } else {
            this.execute(string5, true);
        }
    }

    private void loadPreview() {
        this.loadInR(this.previewName, true);
        try {
            JGR.eval(".refreshObjects()");
        }
        catch (REngineException rEngineException) {
            new ErrorMsg(rEngineException);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            new ErrorMsg(rEXPMismatchException);
        }
        RObject rObject = new RObject(this.previewName, "data.frame", null, false);
        SVarSet sVarSet = RController.newSet(rObject);
        DataTable dataTable = new DataTable(sVarSet, "data.frame", false, false);
        this.dataTable.setModel(dataTable.getJTable().getModel());
        this.dataTable.setTableHeader(dataTable.getJTable().getTableHeader());
        dataTable.dispose();
        try {
            REXPLogical rEXPLogical = (REXPLogical)JGR.eval("\"" + this.previewName + "\" %in% ls()");
            if (rEXPLogical.isTRUE()[0]) {
                JGR.eval("rm(" + this.previewName + ")");
            }
        }
        catch (REngineException rEngineException) {
            new ErrorMsg(rEngineException);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            new ErrorMsg(rEXPMismatchException);
        }
    }

    public void execute(String string, boolean bl) {
        JGR.MAINRCONSOLE.execute(string, bl);
    }

    private void loadActionPerformed(ActionEvent actionEvent) {
        this.loadInR(this.dataName, false);
        this.dispose();
    }

    private void cancelActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void sepsBoxActionPerformed(ActionEvent actionEvent) {
        this.loadPreview();
    }

    private void quoteBoxActionPerformed(ActionEvent actionEvent) {
        this.loadPreview();
    }

    private void headerActionPerformed(ActionEvent actionEvent) {
        this.loadPreview();
    }

    public void dispose() {
        super.dispose();
    }
}

