% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLM_Signal_2D_support.R
\name{dev_calc}
\alias{dev_calc}
\title{Deviance calculation for GLM P-spline fitting.}
\usage{
dev_calc(
  family = "gaussian",
  y,
  mu,
  m_binomial = 0 * y + 1,
  r_gamma = 0 * y + 1
)
}
\arguments{
\item{family}{the response distribution, e.g. \code{"gaussian", "binomial", "poisson", "Gamma"} distribution. Quotes are needed; default \code{"family = gaussian"}.}

\item{y}{the glm response vector of length \code{m}.}

\item{mu}{the P-spline estimated mean for the glm response vector of length \code{m}.}

\item{m_binomial}{a vector of binomial trials having \code{length(y)}, when \code{family = "binomial"}. Default is 1 vector.}

\item{r_gamma}{a vector of gamma shape parameters, when \code{family = "Gamma"}. Default is 1 vector.}
}
\value{
A list with two fields:
\item{dev}{the estimated deviance.}
\item{dispersion_parm}{the ML estimated dispersion parameter.}
}
\description{
Calculates the deviance and returns the ML estimated dispersion parameter
for a variety of response distributions for P-spline fitting within the GLM framework.
}
