% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{TukeyHSDgg}
\alias{TukeyHSDgg}
\title{Tukey HSD Plot}
\usage{
TukeyHSDgg(x, y, d, ci = 0.95, idvar, ...)
}
\arguments{
\item{x}{A categorical grouping variable name.}

\item{y}{A continuous outcome variable name.}

\item{d}{A dataset}

\item{ci}{A numeric value indicating the coverage of the
confidence interval to use.  Defaults to 0.95.}

\item{idvar}{An optional ID variable for multilevel data}

\item{\ldots}{Additional arguments passed on.}
}
\value{
A ggplot graph object.
}
\description{
This calculates and displays means, confidence intervals
as well as which groups are different based on Tukey's HSD.
Inspired by http://stackoverflow.com/questions/18771516/is-there-a-function-to-add-aov-post-hoc-testing-results-to-ggplot2-boxplot
}
\examples{

## examples using it with single level data
## differences based on an ANOVA and follow up contrasts
TukeyHSDgg("cyl", "mpg", mtcars)
TukeyHSDgg("Species", "Sepal.Length", iris)

## example based on multilevel data
## differences based on model fit with lmer and follow up contrasts
TukeyHSDgg("treatment", "decrease", OrchardSprays, idvar = "colpos")
}
\keyword{plot}
