% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{detailedTests}
\alias{detailedTests}
\title{Detailed Comparisons and Tests on Models}
\usage{
detailedTests(obj, ...)
}
\arguments{
\item{obj}{A fitted model object, currently either a
\code{merMod} or \code{vglm} class object.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
Depends on the method dispatch,
 see \code{.detailedTestsLMER} and \code{.detailedTestsVGLM}.
}
\description{
TODO: make me!
}
\examples{
mtcars$cyl <- factor(mtcars$cyl)
m <- VGAM::vglm(cyl ~ qsec,
  family = VGAM::multinomial(), data = mtcars)
detailedTests(m)
rm(m, mtcars)

\dontrun{
mtcars$cyl <- factor(mtcars$cyl)
mtcars$am <- factor(mtcars$am)
m <- VGAM::vglm(cyl ~ qsec,
  family = VGAM::multinomial(), data = mtcars)
detailedTests(m)

detailedTests(m, digits = 4)$Table
detailedTests(m, OR = FALSE)
detailedTests(m, digits = 4, OR = FALSE)$Table

m <- VGAM::vglm(cyl ~ scale(qsec),
  family = VGAM::multinomial(), data = mtcars)
detailedTests(m)

m2 <- VGAM::vglm(cyl ~ factor(vs) * scale(qsec),
  family = VGAM::multinomial(), data = mtcars)
detailedTests(m2)

m <- VGAM::vglm(Species ~ Sepal.Length,
  family = VGAM::multinomial(), data = iris)
detailedTests(m)

data(aces_daily)
m1 <- lme4::lmer(NegAff ~ STRESS + (1 + STRESS | UserID),
  data = aces_daily)
m2 <- lme4::lmer(NegAff ~ STRESS + I(STRESS^2) + (1 + STRESS | UserID),
  data = aces_daily)
testm1 <- detailedTests(m1, method = "profile")
testm2 <- detailedTests(m2, method = "profile")
testm2b <- detailedTests(m2, method = "boot", nsim = 100)
}
}
