% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{iccMixed}
\alias{iccMixed}
\title{Intraclass Correlation Coefficient (ICC) from Mixed Models}
\usage{
iccMixed(dv, id, data, family = c("gaussian", "binomial"))
}
\arguments{
\item{dv}{A character string giving the variable name of
the dependent variable.}

\item{id}{A character vector of length one or more giving
the ID variable(s).  Can be more than one.}

\item{data}{A data.table containing the variables
used in the formula.  This is a required argument.
If a data.frame, it will silently coerce to a data.table.
If not a data.table or data.frame, it will attempt to coerce,
with a message.}

\item{family}{A character vector giving the family to use
for the model.  Currently only supports
\dQuote{gaussian} or \dQuote{binomial}.}
}
\value{
A data table of the ICCs
}
\description{
This function estimates the ICC from mixed effects models
estimated using \pkg{lme4}.
}
\examples{
iccMixed("mpg", "cyl", mtcars)
iccMixed("mpg", "cyl", as.data.table(mtcars))
iccMixed("mpg", "cyl", as.data.table(mtcars), family = "gaussian")
iccMixed("mpg", c("cyl", "am"), as.data.table(mtcars))
iccMixed("am", "cyl", as.data.table(mtcars), family = "binomial")
}
\references{
For details, see
Campbell, M. K., Mollison, J., & Grimshaw, J. M. (2001).
Cluster trials in implementation research: estimation of
intracluster correlation coefficients and sample size.
\emph{Statistics in Medicine, 20}(3), 391-399.
}
\keyword{multivariate}
