% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{residualDiagnostics}
\alias{residualDiagnostics}
\alias{as.residualDiagnostics}
\alias{is.residualDiagnostics}
\alias{residualDiagnostics.lm}
\title{Residual Diagnostics Functions}
\usage{
residualDiagnostics(object, ...)

as.residualDiagnostics(x)

is.residualDiagnostics(x)

\method{residualDiagnostics}{lm}(
  object,
  ev.perc = 0.001,
  robust = FALSE,
  distr = "normal",
  standardized = TRUE,
  cut = 4L,
  ...
)
}
\arguments{
\item{object}{A fitted model object, with methods for
\code{model.frame}, \code{resid} and \code{fitted}.}

\item{...}{Additional arguments, not currently used.}

\item{x}{A object (e.g., list or a modelDiagnostics object) to
test or attempt coercing to a residualDiagnostics object.}

\item{ev.perc}{A real number between 0 and 1 indicating the
proportion of the theoretical distribution beyond which
values are considered extreme values (possible outliers).
Defaults to .001.}

\item{robust}{Whether to use robust mean and standard deviation estimates
for normal distribution}

\item{distr}{A character string given the assumed distribution.
Passed on to \code{\link{testDistribution}}.
Defaults to \dQuote{normal}.}

\item{standardized}{A logical whether to use standardized residuals.
Defaults to \code{TRUE} generally where possible but may depend on
method.}

\item{cut}{An integer, how many unique predicted values
there have to be at least for predicted values to be
treated continuously, otherwise they are treated as discrete values.
Defaults to 4.}
}
\value{
A logical (\code{is.residualDiagnostics}) or
  a residualDiagnostics object (list) for
  \code{as.residualDiagnostics} and \code{residualDiagnostics}.
}
\description{
A set of functions to calculate
  residual diagnostics on models, including constructors,
  a generic function, a test of whether an object is of the
  \code{residualDiagnostics} class, and methods.
}
\examples{
testm <- stats::lm(mpg ~ hp * factor(cyl), data = mtcars)

resm <- residualDiagnostics(testm)
plot(resm$testDistribution)

resm <- residualDiagnostics(testm, standardized = FALSE)
plot(resm$testDistribution)

## clean up
rm(testm, resm)
\dontrun{

testdat <- data.frame(
  y = c(1, 2, 2, 3, 3, NA, 9000000, 2, 2, 1),
  x = c(1, 2, 3, 4, 5, 6, 5, 4, 3, 2))

residualDiagnostics(
  lm(y ~ x, data = testdat, na.action = "na.omit"),
  ev.perc = .1)$Residuals

residualDiagnostics(
  lm(y ~ x, data = testdat, na.action = "na.exclude"),
  ev.perc = .1)$Residuals

residualDiagnostics(
  lm(sqrt(mpg) ~ hp, data = mtcars, na.action = "na.omit"),
  ev.perc = .1)$Residuals
}
}
