/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.ClassEnv;
import jas.CodeAttr;
import jas.InsnOperand;
import jas.RuntimeConstants;
import java.io.DataOutputStream;
import java.io.IOException;

class UnsignedByteWideOperand
extends InsnOperand
implements RuntimeConstants {
    int val;

    UnsignedByteWideOperand(int n) {
        this.val = n;
    }

    int size(ClassEnv ce, CodeAttr code) {
        if (this.val >= 256) {
            return 3;
        }
        return 1;
    }

    void writePrefix(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException {
        if (this.val > 255) {
            out.writeByte(-60);
        }
    }

    void write(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException {
        if (this.val > 255) {
            out.writeShort((short)(0xFFFF & this.val));
            return;
        }
        out.writeByte((byte)(this.val & 0xFF));
    }

    void resolve(ClassEnv e) {
    }
}

