/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.DataStructures.Data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Vector;
import org.omegahat.DataStructures.Data.FilterDataList;
import org.omegahat.Environment.DataStructures.AssignableSubset;
import org.omegahat.Environment.DataStructures.Subsettable;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Language.Evaluable;
import org.omegahat.Environment.Language.Function;
import org.omegahat.Environment.Parser.Parse.AssignExpression;
import org.omegahat.Environment.Parser.Parse.List;
import org.omegahat.Environment.Parser.Parse.MethodCall;
import org.omegahat.Environment.Parser.Parse.Name;
import org.omegahat.Environment.System.Globals;
import org.omegahat.Environment.Tools.DataScanner.EventDataScanner;
import org.omegahat.Environment.Tools.DataScanner.ObjectReader;
import org.omegahat.Environment.Tools.DataScanner.RecordStreamListener;

public class DataList
extends Vector
implements RecordStreamListener,
Subsettable,
AssignableSubset,
Serializable {
    public static final int ROWS = 0;
    public static final int COLUMNS = 1;
    protected Vector[] names = new Vector[2];
    protected Object[] data;
    protected int currentNum = 0;

    public DataList() {
    }

    public DataList(int n) {
        super(n);
        this.data = new Object[n];
    }

    public DataList(File file) throws FileNotFoundException {
        this((ObjectReader)new EventDataScanner((Reader)new FileReader(file)));
    }

    public DataList(ObjectReader objectReader) {
        objectReader.addListener((RecordStreamListener)this);
    }

    public DataList(ObjectReader objectReader, int n) {
        this(n);
        objectReader.addListener((RecordStreamListener)this);
    }

    public DataList(Object[] objectArray) {
        this.data(objectArray);
    }

    public void addRecord(Object object) {
        if ((object = this.processElement(object)) != null) {
            super.addElement(object);
        }
    }

    public DataList apply(Function function) {
        try {
            return this.apply(function, Globals.evaluator());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Can't obtain an evaluator");
        }
    }

    public DataList apply(Function function, Vector vector) {
        try {
            return this.apply(function, Globals.evaluator(), vector);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Can't obtain an evaluator");
        }
    }

    public DataList apply(Function function, Evaluator evaluator) {
        return this.apply(function, evaluator, this);
    }

    public DataList apply(Function function, Evaluator evaluator, Vector vector) {
        DataList dataList = new DataList(vector.size());
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            List list = this.createArgumentList(e, function);
            Object object = null;
            try {
                object = function.eval(list, evaluator);
            }
            catch (Throwable throwable) {
                evaluator.warning("Apply failed on element " + n);
                object = Database.NULL_ENTRY;
            }
            dataList.addElement(object);
            ++n;
        }
        return dataList;
    }

    public DataList apply(MethodCall methodCall, Evaluator evaluator) {
        return this.apply(methodCall, evaluator, new List(0));
    }

    public DataList apply(MethodCall methodCall, Evaluator evaluator, List list) {
        DataList dataList = new DataList(this.size());
        int n = 0;
        while (n < this.size()) {
            Object e = this.elementAt(n);
            Object object = null;
            try {
                object = methodCall.findEvalMethod(list, e, evaluator, false);
            }
            catch (Throwable throwable) {
                evaluator.warning("Apply failed on element " + n);
                throwable.printStackTrace();
                object = Database.NULL_ENTRY;
            }
            dataList.addElement(object);
            ++n;
        }
        return dataList;
    }

    public Object assignSubset(Object object, Object object2) {
        return object2;
    }

    public Vector columnNames() {
        return this.names(1);
    }

    public Vector columnNames(Vector vector) {
        return this.names(1, vector);
    }

    public Vector columnNames(String[] stringArray) {
        return this.names(0, stringArray);
    }

    protected List createArgumentList(Object object, Function function) {
        String string = (String)function.argumentNames().elementAt(0);
        List list = new List((Object)new AssignExpression((Object)new Name(string), object));
        return list;
    }

    public int data(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.addElement(objectArray[n]);
            ++n;
        }
        return this.size();
    }

    public Vector names(int n) {
        return this.names[n];
    }

    public Vector names(int n, Vector vector) {
        this.names[n] = vector;
        return this.names(n);
    }

    public Vector names(int n, String[] stringArray) {
        return this.names(n, this.toVector(stringArray));
    }

    public boolean newRecord(Object object, ObjectReader objectReader) {
        if ((object = this.processElement(object)) != null) {
            super.addElement(object);
        }
        return true;
    }

    public Object processElement(Object object) {
        return object;
    }

    public Vector rowNames() {
        return this.names(0);
    }

    public Vector rowNames(Vector vector) {
        return this.names(0, vector);
    }

    public Vector rowNames(String[] stringArray) {
        return this.names(0, this.toVector(stringArray));
    }

    public Object subset(Object object, boolean bl) throws Throwable {
        Object object2 = null;
        if (object instanceof List) {
            FilterDataList filterDataList = new FilterDataList(this);
            int n = ((List)object).size();
            int n2 = 0;
            while (n2 < n) {
                object2 = ((List)object).elementAt(n2);
                filterDataList.addElement(this.subset(object2, false));
                ++n2;
            }
            object2 = ((List)object).size() == 1 ? filterDataList.elementAt(0) : filterDataList;
        } else if (object instanceof Function) {
            object2 = new FilterDataList(this, (Function)object);
        } else if (object instanceof Evaluable) {
            try {
                Object object3 = ((Evaluable)object).eval(Globals.evaluator());
                object2 = this.subset(object3, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Cannot obtain an evaluator for subset()");
            }
        } else if (object instanceof Number) {
            int n = ((Number)object).intValue();
            object2 = this.elementAt(n);
        }
        return object2;
    }

    public Vector toVector(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        return vector;
    }
}

