/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.GUITools.MethodViewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.omegahat.Environment.GUI.ClassPathViewer;
import org.omegahat.Environment.GUITools.GenericFrame;
import org.omegahat.Environment.GUITools.MethodViewer.MethodTreeModel;
import org.omegahat.Environment.GUITools.MethodViewer.MethodViewer;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.System.Globals;

public class MethodViewerFrame
extends GenericFrame
implements ActionListener,
ListSelectionListener {
    protected MethodViewer viewer;

    public MethodViewerFrame(Class clazz) {
        this(new MethodViewer(clazz));
    }

    public MethodViewerFrame(Class clazz, boolean bl) {
        this(new MethodViewer(new MethodTreeModel(clazz, bl)));
    }

    public MethodViewerFrame(MethodViewer methodViewer) {
        super("Class Element Viewer", false);
        this.viewer(methodViewer);
        this.init(this.viewer());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        boolean bl = false;
        if (actionEvent.getSource() instanceof JTextField) {
            String string2 = ((JTextField)actionEvent.getSource()).getText();
            this.setClass(string2);
            bl = true;
        } else if (actionEvent.getSource() instanceof JButton && (string = actionEvent.getActionCommand()).equals("class")) {
            bl = true;
            try {
                GenericFrame genericFrame = new GenericFrame("Classpath viewer");
                ClassPathViewer classPathViewer = new ClassPathViewer(this.evaluator());
                genericFrame.component(classPathViewer);
                classPathViewer.addSelectionListener(this);
                ((Component)genericFrame).setVisible(true);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (!bl) {
            super.actionPerformed(actionEvent);
        }
    }

    public Evaluator evaluator() throws ClassNotFoundException {
        return Globals.evaluator();
    }

    public Class getClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = this.evaluator().findClass(string);
        }
        catch (Exception exception) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return clazz;
    }

    public void init(MethodViewer methodViewer) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createMenuBar(false), "West");
        JPanel jPanel2 = new JPanel();
        JTextField jTextField = new JTextField(30);
        jTextField.setEditable(true);
        jTextField.addActionListener(this);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jTextField, "Center");
        JButton jButton = new JButton("class");
        jButton.setToolTipText("Click to get class path viewer");
        jButton.addActionListener(this);
        jPanel2.add((Component)jButton, "East");
        jTextField.setToolTipText("Enter name of class and enter");
        jPanel.add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel, "North");
        this.component(methodViewer, true);
        ((Component)this).setBounds(10, 10, 400, 400);
    }

    public Class setClass(String string) {
        Class clazz = null;
        if (string != null && string.length() > 0) {
            if (string.endsWith(".class")) {
                string = string.substring(0, string.length() - ".class".length());
            }
            if ((clazz = this.getClass(string = string.replace('/', '.'))) != null) {
                this.viewer().setClass(clazz);
            } else {
                System.err.println("Couldn't find class " + string);
            }
        }
        return clazz;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        int n = jList.getLeadSelectionIndex();
        if (n > -1) {
            String string = jList.getModel().getElementAt(n).toString();
            this.setClass(string);
        }
    }

    public MethodViewer viewer() {
        return this.viewer;
    }

    public MethodViewer viewer(MethodViewer methodViewer) {
        this.viewer = methodViewer;
        return this.viewer();
    }
}

