/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.GUI;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.omegahat.Environment.GUI.EvaluatorJPanel;
import org.omegahat.Environment.IO.TaskDisplayFilter;
import org.omegahat.Environment.Interpreter.BasicEvaluator;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Interpreter.Task;

public class EvaluatorOutput
extends EvaluatorJPanel
implements TaskDisplayFilter {
    protected JEditorPane display = null;
    protected SimpleAttributeSet taskStringAttributes = null;
    protected SimpleAttributeSet taskValueAttributes = null;

    public EvaluatorOutput(Evaluator evaluator) {
        super(evaluator);
        this.make();
        if (evaluator instanceof BasicEvaluator) {
            ((BasicEvaluator)evaluator).output(this);
        }
    }

    public boolean createDisplayAttributes() {
        this.taskStringAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.taskStringAttributes, Color.green);
        StyleConstants.setFontSize(this.taskStringAttributes, 10);
        this.taskValueAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.taskValueAttributes, Color.blue);
        StyleConstants.setFontSize(this.taskValueAttributes, 11);
        return true;
    }

    URL defaultPage() {
        URL uRL = this.getClass().getResource("defaultTaskResultPage.html");
        return uRL;
    }

    public boolean display(Object object) {
        return true;
    }

    public boolean display(Object object, long l) {
        return true;
    }

    public boolean display(Task task) {
        if (this.taskStringAttributes == null) {
            this.createDisplayAttributes();
        }
        Document document = this.display.getDocument();
        try {
            document.insertString(document.getEndPosition().getOffset() - 1, "\n" + task.taskString().trim(), this.taskStringAttributes);
            document.insertString(document.getEndPosition().getOffset() - 1, "\n" + task.value(), this.taskValueAttributes);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return true;
    }

    public boolean make() {
        try {
            this.display = new JEditorPane(this.defaultPage());
            this.display = new JTextPane();
            this.display.setEditable(false);
            System.err.println("Editor kit " + this.display.getEditorKit().getClass());
            JScrollPane jScrollPane = new JScrollPane(this.display);
            this.add("Center", jScrollPane);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public String toString(Object object) {
        return object.toString();
    }

    public Writer toWriter(Object object) {
        return null;
    }

    public Writer writer() {
        return null;
    }
}

