/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Interpreter;

import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import org.omegahat.Environment.Utils.TrimmedProperties;

public class Options
extends TrimmedProperties {
    public static int NORMAL = 0;
    public static int CONTINUE = 1;
    public String DebugProperty = "debug";
    public String ParserDebugProperty = "parserDebug";
    public static final int PROMPT = 0;
    public static final int CONTINUE_PROMPT = 1;
    public static String DefaultPrompt = "$ > ";
    protected boolean parserDebug = false;
    protected boolean parsePrompt = true;

    public Options() {
        String string = System.getProperty("OMEGA_CONFIG_FILE");
        if (string == null) {
            InputStream inputStream = this.getClass().getResourceAsStream("OmegaOptions");
            if (inputStream != null) {
                this.load(inputStream);
            }
            return;
        }
        if (string == null) {
            return;
        }
        File file = new File(string);
        this.load(file);
    }

    public Options(File file) {
        super(file);
    }

    public Options(InputStream inputStream) {
        super(inputStream);
    }

    public Options(String string) {
        super(string);
    }

    public String getProperty(String string) {
        if (((Hashtable)this).containsKey(string)) {
            return super.getProperty(string);
        }
        return System.getProperty(string);
    }

    public String getProperty(String string, String string2, boolean bl) {
        if (bl) {
            if (((Hashtable)System.getProperties()).containsKey(string)) {
                return System.getProperties().getProperty(string);
            }
            return super.getProperty(string, string2);
        }
        return this.getProperty(string, string2);
    }

    public String getProperty(String string, boolean bl) {
        if (bl) {
            if (((Hashtable)System.getProperties()).containsKey(string)) {
                return System.getProperties().getProperty(string);
            }
            return super.getProperty(string);
        }
        return this.getProperty(string);
    }

    public synchronized void load(InputStream inputStream) {
        super.load(inputStream);
        this.processProperties();
    }

    public boolean parserDebug() {
        return this.parserDebug;
    }

    public boolean parserDebug(boolean bl) {
        this.parserDebug = bl;
        return this.parserDebug();
    }

    public int processProperties() {
        int n = 0;
        if (this.getProperty(this.ParserDebugProperty) != null) {
            this.parserDebug(new Boolean(this.getProperty(this.ParserDebugProperty)));
            ++n;
        }
        return n;
    }

    public String prompt() {
        return this.prompt(0);
    }

    public String prompt(int n) {
        String string = null;
        if (n == NORMAL) {
            string = this.getProperty("prompt", null, true);
            if (string == null) {
                string = ">";
                this.parsePrompt = false;
            }
        } else {
            string = this.getProperty("continue", ">> ", true);
        }
        return string;
    }
}

