% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{traceplot}
\alias{traceplot}
\alias{traceplot.JointAI}
\title{Create traceplots for a MCMC sample}
\usage{
traceplot(object, ...)

\method{traceplot}{JointAI}(object, start = NULL, end = NULL,
  thin = NULL, subset = c(analysis_main = TRUE), outcome = NULL,
  exclude_chains = NULL, nrow = NULL, ncol = NULL, use_ggplot = FALSE,
  warn = TRUE, mess = TRUE, ...)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{...}{
  Arguments passed on to \code{\link[graphics:matplot]{graphics::matplot}}
  \describe{
    \item{\code{lty}}{vector of line types, widths, and end styles.
    The first element is for the first column, the second element for
    the second column, etc., even if lines are not plotted for all
    columns. Line types will be used cyclically until all plots are
    drawn.}
    \item{\code{lwd}}{vector of line types, widths, and end styles.
    The first element is for the first column, the second element for
    the second column, etc., even if lines are not plotted for all
    columns. Line types will be used cyclically until all plots are
    drawn.}
    \item{\code{lend}}{vector of line types, widths, and end styles.
    The first element is for the first column, the second element for
    the second column, etc., even if lines are not plotted for all
    columns. Line types will be used cyclically until all plots are
    drawn.}
    \item{\code{col}}{vector of colors.  Colors are used cyclically.}
    \item{\code{cex}}{vector of character expansion sizes, used cyclically.
    This works as a multiple of \code{\link[graphics]{par}("cex")}.  \code{NULL} is
    equivalent to \code{1.0}. }
    \item{\code{bg}}{vector of background (fill) colors for the open plot
    symbols given by \code{pch = 21:25} as in \code{\link[graphics]{points}}.  The
    default \code{NA} corresponds to the one of the underlying function
    \code{\link[graphics]{plot.xy}}.}
    \item{\code{add}}{logical.  If \code{TRUE}, plots are added to current one,
    using \code{\link[graphics]{points}} and \code{\link[graphics]{lines}}.}
    \item{\code{verbose}}{logical.  If \code{TRUE}, write one line of what is
    done.}
  }}

\item{start}{the first iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (integer; see \code{\link[coda]{window.mcmc}}).
For example, \code{thin = 1} (default) will keep the MCMC samples
from all iterations; \code{thin = 5} would only keep every 5th
iteration.}

\item{subset}{subset of parameters/variables/nodes (columns in the MCMC
sample). Follows the same principle as the argument
\code{monitor_params} in
\code{\link[JointAI:model_imp]{*_imp}}.}

\item{outcome}{optional; vector identifying a subset of sub-models included
in the output, either by specifying their indices (using the
order used in the list of model formulas), or their
names (LHS of the respective model formula as character
string)}

\item{exclude_chains}{optional vector of the index numbers of chains that
should be excluded}

\item{nrow}{optional; number of rows in the plot layout;
automatically chosen if unspecified}

\item{ncol}{optional; number of columns in the plot layout;
automatically chosen if unspecified}

\item{use_ggplot}{logical; Should ggplot be used instead of the base
graphics?}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}.}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}.}
}
\description{
Creates a set of traceplots from the MCMC sample of an object of class
'JointAI'.
}
\examples{
# fit a JointAI model
mod <- lm_imp(y ~ C1 + C2 + M1, data = wideDF, n.iter = 100)


# Example 1: simple traceplot
traceplot(mod)


# Example 2: ggplot version of traceplot
traceplot(mod, use_ggplot = TRUE)


# Example 5: changing how the ggplot version looks (using ggplot syntax)
library(ggplot2)

traceplot(mod, use_ggplot = TRUE) +
  theme(legend.position = 'bottom') +
  xlab('iteration') +
  ylab('value') +
  scale_color_discrete(name = 'chain')


}
\seealso{
\code{\link{summary.JointAI}},
\code{\link[JointAI:model_imp]{*_imp}},
\code{\link{densplot}}\cr
The vignette
\href{https://nerler.github.io/JointAI/articles/SelectingParameters.html}{Parameter Selection}
contains some examples how to specify the parameter \code{subset}.
}
