% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_wrap.R
\name{julia_pkg_wrap}
\alias{julia_pkg_wrap}
\alias{julia_function}
\alias{julia_pkg_import}
\alias{julia_pkg_hook}
\title{Wrap julia functions and packages the easy way.}
\usage{
julia_function(func_name, pkg_name = "Main", env = new.env(emptyenv()))

julia_pkg_import(pkg_name, func_list, env = new.env(parent = emptyenv()))

julia_pkg_hook(env, hook)
}
\arguments{
\item{func_name}{the julia function name to be wrapped.}

\item{pkg_name}{the julia package name to be wrapped.}

\item{env}{the environment where the functions and packages
are wrapped.}

\item{func_list}{the list of julia function names to
be wrapped.}

\item{hook}{the function to be executed
before the execution of wrapped functions.}
}
\description{
Wrap julia functions and packages the easy way.
}
\examples{
\donttest{ ## julia_setup is quite time consuming
  ## do initialization and automatic installation of Julia if necessary
  julia_setup(installJulia = TRUE)
  julia_install_package_if_needed("Optim")
  opt <- julia_pkg_import("Optim",
                           func_list = c("optimize", "BFGS"))
rosenbrock <- function(x) (1.0 - x[1])^2 + 100.0 * (x[2] - x[1]^2)^2
result <- opt$optimize(rosenbrock, rep(0,2), opt$BFGS())
result
}

}
