% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SSMarima.R, R/SSMcustom.R, R/SSMcycle.R, R/SSModel.R, R/SSMregression.R, R/SSMseasonal.R, R/SSMtrend.R
\name{SSMarima}
\alias{SSMarima}
\alias{SSMcustom}
\alias{SSMcycle}
\alias{SSModel}
\alias{SSMregression}
\alias{SSMseasonal}
\alias{SSMtrend}
\title{Create a State Space Model Object of Class SSModel}
\usage{
SSMarima(ar = NULL, ma = NULL, d = 0, Q, stationary = TRUE, index, n,
  ynames)

SSMcustom(Z, T, R, Q, a1, P1, P1inf, index, n)

SSMcycle(period, Q, type, index, a1, P1, P1inf, n, ynames)

SSModel(formula, data, H, u, distribution, tol = .Machine$double.eps^0.5)

SSMregression(rformula, data, type, Q, index, R, a1, P1, P1inf, n, ynames,
  remove.intercept = TRUE)

SSMseasonal(period, Q, sea.type = c("dummy", "trigonometric"), type, index,
  a1, P1, P1inf, n, ynames)

SSMtrend(degree = 1, Q, type, index, a1, P1, P1inf, n, ynames)
}
\arguments{
\item{ar}{for arima component, a numeric vector containing the autoregressive
coeffients.}

\item{ma}{for arima component, a numericvector containing the moving average
coeffients.}

\item{d}{for arima component, a degree of differencing.}

\item{Q}{for arima, cycle and seasonal component, a \eqn{p \times p}{p x p}
covariance matrix of the disturbances (or in the time varying case \eqn{p
\times p \times n}{p x p x n} array), where where p=\code{length(index)}.
For trend component, list of length \code{degree} containing the \eqn{p
\times p} or \eqn{p \times p \times n} covariance matrices. For a custom
component, arbitrary covariance matrix or array of disturbance terms
\eqn{\eta_t}{\eta[t]}}

\item{stationary}{for arima component, logical value indicating whether a
stationarity of the arima part is assumed. Defaults to TRUE.}

\item{index}{a vector indicating for which series the corresponding
components are constructed.}

\item{n}{length of the series, only used internally for dimensionality check.}

\item{ynames}{names of the times series, only used internally.}

\item{Z}{for a custom component, system matrix or array of observation
equation.}

\item{T}{for a custom component, system matrix or array of transition
equation.}

\item{R}{for a custom and regression components, optional \eqn{m \times k}
system matrix or array of transition equation.}

\item{a1}{optional \eqn{m \times 1}{m x 1} matrix giving the expected value
of the initial state vector \eqn{\alpha_1}{\alpha[1]}.}

\item{P1}{optional \eqn{m \times m}{m x m} matrix giving the covariance
matrix of \eqn{\alpha_1}{\alpha[1]}.  In the diffuse case the non-diffuse
part of \eqn{P_1}{P[1]}.}

\item{P1inf}{optional \eqn{m \times m}{m x m} matrix giving the diffuse part
of \eqn{P_1}{P[1]}. Diagonal matrix with ones on diagonal elements which
correspond to the unknown initial states.}

\item{period}{for a cycle and seasonal components, the length of the
cycle/seasonal pattern.}

\item{type}{for cycle, seasonal, trend and regression components, character
string defining if \code{'distinct'} or \code{'common'} states are used for
different series.}

\item{formula}{an object of class \code{\link{formula}} containing the
symbolic description of the model. The intercept term can be removed with
\code{-1} as in \code{lm}. In case of trend or differenced arima component
intercept is removed automatically in order to keep the model identifiable.
See details and examples in \code{\link{KFAS}} for special functions used in model construction.}

\item{data}{an optional data frame, list or environment containing the
variables in the model.}

\item{H}{covariance matrix or array of disturbance terms
\eqn{\epsilon_t}{\epsilon[t]} of observation equation. Defaults to an identity matrix. Omitted in case of
non-Gaussian distributions. Augment the state vector if you want to add
additional noise.}

\item{u}{additional parameters for non-Gaussian models. See details in
\code{\link{KFAS}}.}

\item{distribution}{a vector of distributions of the observations. Default is
\code{rep("gaussian",p)}, where \code{p} is the number of series.}

\item{tol}{a tolerance parameter used in checking whether \code{Finf} or \code{F} is numerically zero.
Defaults to \code{.Machine$double.eps^0.5}. Ifsmoothing gives negative variances for
smoothed states, try adjusting this.#'}

\item{rformula}{for regression component, right hand side formula or list of
of such formulas defining the custom regression part.}

\item{remove.intercept}{Remove intercept term from regression model. Default
is \code{TRUE}. This tries to ensure that there are no extra intercept
terms in the model.}

\item{sea.type}{for seasonal component, character string defining whether to
use \code{"dummy"} or \code{"trigonometric"} form of the seasonal
component.}

\item{degree}{for trend component, integer defining the degree of the
polynomial trend. 1 corresponds to local level, 2 for local linear trend
and so forth.}
}
\value{
object of class \code{SSModel}, which is a list with the following
  components:
  \item{y}{A n x p matrix containing the observations. }
  \item{Z}{A p x m x 1 or p x m x n array corresponding to the system matrix
  of observation equation. }
  \item{H}{A p x p x 1 or p x p x n array
  corresponding to the covariance matrix of observational disturbances
  epsilon. }
  \item{T}{A m x m x 1 or m x m x n array corresponding to the
  first system matrix of state equation. }
  \item{R}{A m x k x 1 or m x k x n
  array corresponding to the second system matrix of state equation. }
  \item{Q}{A k x k x 1 or k x k x n array corresponding to the covariance
  matrix of state disturbances eta }
  \item{a1}{A m x 1 matrix containing the
  expected values of the initial states. }
  \item{P1}{A m x m matrix
  containing the covariance matrix of the nondiffuse part of the initial
  state vector. }
  \item{P1inf}{A m x m matrix containing the covariance
  matrix of the diffuse part of the initial state vector. }
  \item{u}{A n x p
  matrix of an additional parameters in case of non-Gaussian model.}
  \item{distribution}{A vector of length p giving the distributions of the
  observations. }
  \item{tol}{A tolerance parameter for the diffuse phase. }
  \item{call}{Original call to the function. } In addition, object of class
  \code{SSModel} contains following attributes:
  \item{names}{Names of the
  list components. }
  \item{p, m, k, n}{Integer valued scalars defining the
  dimensions of the model components. }
  \item{state_types}{Types of the
  states in the model. }
  \item{eta_types}{Types of the
  state disturbances in the model. }
  \item{tv}{Integer vector stating whether \code{Z},\code{H},\code{T},\code{R} or \code{Q} is
   time-varying (indicated by 1 in \code{tv} and 0 otherwise). }
}
\description{
Function \code{SSModel} creates a state space object object of class
\code{SSModel} which can be used as an input object for various functions of
\code{KFAS} package.
}
\details{
Formula of the model can contain the usual regression part and additional
functions defining different types of components of the model, named as
\code{SSMarima}, \code{SSMcustom}, \code{SSMcycle}, \code{SSMregression},
\code{SSMseasonal} and \code{SSMtrend}.
}
\examples{
# example of using data argument
y <- x <- rep(1,3)
data1 <- data.frame(x=rep(2,3))
data2 <- data.frame(x=rep(3,3))

f <- formula(~-1+x)
# With data missing the environment of formula is checked,
# and if not found in there a calling environment via parent.frame is checked.

c(SSModel(y~-1+x)["Z"]) # 1 1 1
c(SSModel(y~-1+x,data=data1)["Z"]) # 2 2 2

c(SSModel(y~-1+SSMregression(~-1+x))["Z"]) # 1 1 1
c(SSModel(y~-1+SSMregression(~-1+x,data=data1))["Z"]) # 2 2 2
c(SSModel(y~-1+SSMregression(~-1+x),data=data1)["Z"]) # 2 2 2
SSModel(y~-1+x+SSMregression(~-1+x,data=data1))["Z"] # 1 and 2
SSModel(y~-1+x+SSMregression(~-1+x),data=data1)["Z"] # both are 2
SSModel(y~-1+x+SSMregression(~-1+x,data=data1),data=data2)["Z"] # 3 and 2

SSModel(y~-1+x+SSMregression(f))["Z"] # 1 and 1
SSModel(y~-1+x+SSMregression(f),data=data1)["Z"] # 2 and 1
SSModel(y~-1+x+SSMregression(f,data=data1))["Z"] # 1 and 2

rm(x)
c(SSModel(y~-1+SSMregression(f,data=data1))$Z) # 2
\dontrun{
# This fails as there is no x in the environment of f
c(SSModel(y~-1+SSMregression(f),data=data1)$Z)
}
}
\seealso{
\code{artransform}

\code{\link{KFAS}} for examples.
}

