% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLinkedPairs.R
\name{getLinkedPairs}
\alias{getLinkedPairs}
\title{Identify linked marker pairs}
\usage{
getLinkedPairs(markers, linkageMap, maxdist = Inf)
}
\arguments{
\item{markers}{A character vector containing marker names.}

\item{linkageMap}{A data frame with columns including \code{Marker}, \code{Chrom} and
\code{PosCM}.}

\item{maxdist}{A positive number indicating the maximum linkage distance (in
cM). Markers further apart than this are considered unlinked.}
}
\value{
A list of character vectors, each containing two marker names.
}
\description{
This function returns a "maximal" set of disjoint pairs of linked markers,
given a genetic marker map and a subset of the markers included in the map.
The pairs are identified in a greedy manner, successively choosing the
closest markers on each chromosome.
}
\examples{
# Example using the built-in map of 50 STR markers
map = KLINK::LINKAGEMAP

getLinkedPairs(map$Marker, map, maxdist = 25)
}
