% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstandardKspm.R
\name{rstandard.kspm}
\alias{rstandard.kspm}
\title{Standardized residuals for Kernel Semi parametric Model Fits}
\usage{
\method{rstandard}{kspm}(model, ...)
}
\arguments{
\item{model}{an model of class "kspm", usually, a result of a call to \code{kspm}.}

\item{...}{furter arguments passed to or from other methods (currently unused).}
}
\value{
a vector containing the standardized residuals.
}
\description{
computes standardized residuals for an object of class "kspm".
}
\details{
Standardized residuals \eqn{t_i}{t_i} are obtained by \eqn{t_i = \frac{e_i}{\hat{\sigma} \sqrt{1 - h_{ii}}}}{t_i = e_i / hat(sigma) sqrt(1 - h_ii)} where \eqn{e_i}{e_i} is the residual, \eqn{\hat{\sigma}}{hat(sigma)} is the estimated standard deviation of the errors and \eqn{h_{ii}}{h_ii} is the leverage of subject i, i.e. the i th diagonal element of the Hat matrix.
}
\seealso{
\link{kspm} for fitting model, \link{residuals.kspm}, \link{cooks.distance.kspm}, \link{plot.kspm}.
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
