% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryKspm.R
\name{summary.kspm}
\alias{summary.kspm}
\title{Summarizing Kernel Semi parametric Model Fits}
\usage{
\method{summary}{kspm}(object, kernel.test = "all",
  global.test = FALSE, ...)
}
\arguments{
\item{object}{an object of class "kspm", usually, a result of a call to \code{kspm}.}

\item{kernel.test}{vector of characters indicating for which kernel a test should be performed. Default is \code{"all"}. If \code{"none"}, no test will be performed.}

\item{global.test}{logical, if \code{TRUE}, a global test for kernel part is computed.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Computes and returns the followimg summary statistics of the fitted kernel semi parametric model given in object
  \item{residuals}{residuals}
  \item{coefficients}{a \eqn{p \times 4}{p x 4} matrix with columns for the estimated coefficient, its standard error, t statistic and corresponding (two sided) p value for the linear part of the model.}
  \item{sigma}{the square root of the estimated variance of the random error \eqn{\sigma^2 = \frac{RSS}{edf} }{sigma^2 = RSS / edf} where \eqn{RSS}{RSS} is the residual sum of squares and \eqn{edf}{edf} is the effective degree of freedom.}
  \item{edf}{effective degrees of freedom}
  \item{r.squared}{\eqn{R^2}{R^2}, the fraction of variance explained by the model, \eqn{1 - \frac{\sum e_i^2}{\sum(y_i - y^{\ast})^2}}{1 - sum(e_i^2) / sum((y_i - y^star)^2)} where \eqn{y^{\ast}}{y^star} is the mean of \eqn{y_i}{y_i} if there is an intercept and zero otherwise.}
  \item{adj.r.squared}{the above \eqn{R^2}{R^2} statistics, adjusted, penalizing for higher \eqn{p}.}
  \item{score.test}{a \eqn{q \times 3}{q x 3} matrix with colums for the estimated lambda, tau and p value for the q kernels for which a test should be performed.}
  \item{global.p.value}{p value from the score test for the global model.}
  \item{sample.size}{sample size (all: global sample size, inc: complete data sample size).}
}
\description{
summary method for an object of class "kspm"
}
\details{
the description of the model, including coefficients for the linear part and if asked for, test(s) of variance components associated with kernel part.
}
\examples{
x <- 1:15
z1 <- runif(15, 1, 6)
z2 <- rnorm(15, 1, 2)
y <- 3*x + (z1 + z2)^2 + rnorm(15, 0, 2)
fit <- kspm(y, linear = ~ x, kernel = ~ Kernel(~ z1 + z2,
kernel.function = "polynomial", d= 2, rho = 1, gamma = 0))
summary(fit)

}
\references{
Liu, D., Lin, X., and Ghosh, D. (2007). Semiparametric regression of multidimensional genetic pathway data: least squares kernel machines and linear mixed models. Biometrics, 63(4), 1079:1088.

Schweiger, Regev, et al. "RL SKAT: an exact and efficient score test for heritability and set tests." Genetics (2017): genetics 300395.

Li, Shaoyu, and Yuehua Cui. "Gene centric gene gene interaction: A model based kernel machine method." The Annals of Applied Statistics 6.3 (2012): 1134:1161.
}
\seealso{
\link{kspm} for fitting model, \link{predict.kspm} for predictions, \link{plot.kspm} for diagnostics
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
