% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kg_plot_palette.R
\name{kg_plot_color}
\alias{kg_plot_color}
\title{Draw the color data}
\usage{
kg_plot_color(name = "Sapporo_Sta", color = NULL, n = 5, showcode = TRUE)
}
\arguments{
\item{name}{Color palette color palette name. (default: \code{"Sapporo_Sta"})}

\item{color}{Color data. Precedence over name except NULL. (default: NULL)}

\item{n}{Number of colors to create.}

\item{showcode}{Add a color code to the plot.}
}
\value{
Vector containing a hex color code representation for the chosen
palette
}
\description{
\code{kg_plot_color} This function draw the color data.
}
\examples{
#Draw the color palette of the KaradaColor
kg_plot_color(name = "Amanohashidate", n = 5, showcode = FALSE)
#Draw the KG_create_cc command
kg_plot_color(color = kg_create_cc(c("#ff48ac", "yellow")), showcode = TRUE)
#Draw the KG_create_tc command
kg_plot_color(color = kg_create_tc("yellow"), showcode = TRUE)
#Color data
kg_plot_color(color = c("gray"), showcode = FALSE)
}
