% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.oc.obd.kb.R
\name{get.oc.obd.kb}
\alias{get.oc.obd.kb}
\title{Generate Operating Characteristics to Find the Optimal Biological Dose}
\usage{
get.oc.obd.kb(
  toxicity.low,
  toxicity.moderate,
  toxicity.high,
  efficacy.low,
  efficacy.moderate,
  efficacy.high,
  target.toxicity,
  target.efficacy,
  ncohort = 10,
  cohortsize = 3,
  n.early = 100,
  startdose = 1,
  p.true,
  q.true,
  ntrial = 1000,
  seed = 6,
  p1 = 0.15,
  p2 = 0.4,
  q1 = 0.3,
  q2 = 0.6,
  cutoff.eli.toxicity = 0.95,
  cutoff.eli.efficacy = 0.3,
  w1.toxicity = 0.33,
  w2.toxicity = 1.09,
  indicator = target.toxicity
)
}
\arguments{
\item{toxicity.low}{The upper boundary for the low toxicity interval.}

\item{toxicity.moderate}{The upper boundary for the moderate toxicity interval.}

\item{toxicity.high}{The upper boundary for the high toxicity interval.}

\item{efficacy.low}{The upper boundary for the low efficacy interval.}

\item{efficacy.moderate}{The upper boundary for the moderate efficacy interval.}

\item{efficacy.high}{The upper boundary for the high efficacy interval.}

\item{target.toxicity}{The target DLT rate.}

\item{target.efficacy}{The target efficacy rate.}

\item{ncohort}{The total number of cohorts.}

\item{cohortsize}{The number of patients in the cohort.}

\item{n.early}{The early stopping parameter. If the number of patients treated at
the current dose reaches \code{n.early}, then we stop the trial
and select the optimal biological dose (OBD) based on the observed data. The default value is 100.}

\item{startdose}{The starting dose level.}

\item{p.true}{A vector containing the true toxicity probabilities of the
investigational dose levels.}

\item{q.true}{A vector containing the true efficacy probabilities of the
investigational dose levels.}

\item{ntrial}{The total number of trials to be simulated.}

\item{seed}{The random seed for simulation.}

\item{p1}{The cutoff lower limit for safety utility function 1, described in the Details section.}

\item{p2}{The cutoff upper limit for safety utility function 1, described in the Details section.}

\item{q1}{The cutoff lower limit for efficacy utility function 1, described in the Details section.}

\item{q2}{The cutoff upper limit for efficacy utility function 1, described in the Details section.}

\item{cutoff.eli.toxicity}{The cutoff value to eliminate a dose with unacceptable high toxicity for safety. The default value is 0.95.}

\item{cutoff.eli.efficacy}{The cutoff value for the futility rule, the acceptable lowest efficacy. The default value is 0.30.}

\item{w1.toxicity}{The weight for toxicity utility function 2 and 3,described in the Details section.}

\item{w2.toxicity}{The weight for toxicity utility function 3, described in the Details section.}

\item{indicator}{The indicator cutoff value for utility function 3, described in the Details section.}
}
\value{
\code{get.oc.obd.kb()} returns the operating characteristics of the Keyboard design as a list, including:\cr
\enumerate{
   \item the selection percentage at each dose level using utility function 1 (\code{$selpercent1}), \cr
   \item the selection percentage at each dose level using utility function 2 (\code{$selpercent2}), \cr
   \item the selection percentage at each dose level using utility function 3 (\code{$selpercent3}), \cr
   \item the number of patients treated at each dose level (\code{$npatients}), \cr
   \item the number of dose-limiting toxicities (DLTs) observed at each dose level (\code{$ntox}), \cr
   \item the number of responses observed at each dose level (\code{$neff}), \cr
   \item the average number of DLTs (\code{$totaltox}), \cr
   \item the average number of responses (\code{$totaleff}), \cr
   \item the average number of patients (\code{$totaln}), \cr
   \item the percentage of early stopping without selecting the OBD using utility function 1 (\code{$percentstop1}), \cr
   \item the percentage of early stopping without selecting the OBD using utility function 2 (\code{$percentstop2}), \cr
   \item the percentage of early stopping without selecting the OBD using utility function 3 (\code{$percentstop3}), \cr
   \item data.frame (\code{$simu.setup}) containing simulation parameters, such as target, p.true, etc.


}
}
\description{
This function generates operating characteristics to find the  optimal biological dose (OBD).
}
\details{
Large trials are simulated to characterize the operating characteristics of the Keyboard design under the prespecified true toxicity probabilities and true efficacy probabilities of the investigational doses. The dose assignment follows the rules described in the function \code{get.decision.obd.kb()}.

The following stopping rules are built in the Keyboard design:
\enumerate{
\item Stop the trial if the lowest dose is eliminated from the trial due to high unacceptable toxicity.
\item Stop the trial if the number of patients treated at the current dose exceeds \code{n.earlystop}.
}
}
\examples{
\donttest{
toxicity.low <- 0.15
toxicity.moderate <- 0.25
toxicity.high <- 0.35
efficacy.low <- 0.25
efficacy.moderate <- 0.45
efficacy.high <- 0.65
target.toxicity <- 0.30
target.efficacy <- 0.40
p.true <-c(0.08,0.30,0.60,0.80)
q.true <- c(0.25,0.40,0.25,0.50)
oc.obd.kb <- get.oc.obd.kb(toxicity.low = toxicity.low,
             toxicity.moderate= toxicity.moderate,
             toxicity.high = toxicity.high,
             efficacy.low = efficacy.low,
             efficacy.moderate = efficacy.moderate,
             efficacy.high = efficacy.high,
             target.toxicity=target.toxicity,
             target.efficacy= target.efficacy,
             p.true= p.true, q.true= q.true)
oc.obd.kb
summary.kb(oc.obd.kb)
plot.kb(oc.obd.kb)
plot.kb(oc.obd.kb$selpercent1)
plot.kb(oc.obd.kb$selpercent2)
plot.kb(oc.obd.kb$selpercent3)
plot.kb(oc.obd.kb$npatients)
plot.kb(oc.obd.kb$ntox)
plot.kb(oc.obd.kb$neff)
}
}
\references{
Li DH, Whitmore JB, Guo W, Ji Y.  Toxicity and efficacy probability interval design for phase I adoptive cell therapy dose-finding clinical trials.
\emph{Clinical Cancer Research}. 2017; 23:13-20.
https://clincancerres.aacrjournals.org/content/23/1/13.long


Liu S, Johnson VE.  A robust Bayesian dose-finding design for phase I/II clinical trials. \emph{Biostatistics}. 2016; 17(2):249-63.
https://academic.oup.com/biostatistics/article/17/2/249/1744018

Zhou Y, Lee JJ, Yuan Y.  A utility-based Bayesian optimal interval (U-BOIN) phase I/II design to identify the optimal biological dose for targeted and immune therapies. \emph{Statistics in Medicine}. 2019; 38:S5299-5316.
https://onlinelibrary.wiley.com/doi/epdf/10.1002/sim.8361
}
\seealso{
Other single-agent phase I/II functions: 
\code{\link{get.decision.obd.kb}()},
\code{\link{get.decision.obd2.kb}()},
\code{\link{get.oc.obd2.kb}()},
\code{\link{select.obd.kb}()}
}
\author{
Hongying Sun, Li Tang, and Haitao Pan
}
\concept{single-agent phase I/II functions}
