% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.kb.R
\name{plot.kb}
\alias{plot.kb}
\title{Plot Objects Generated by the Keyboard Design Package}
\usage{
\method{plot}{kb}(x, ..., name = deparse(substitute(x)))
}
\arguments{
\item{x}{The object (returned by another function) to be plotted.}

\item{...}{Ignored arguments.}

\item{name}{The name of the object to be plotted.\cr
(Users should not input this parameter).}
}
\value{
This function returns a figure.
}
\description{
This function plots the objects returned by the other functions in the Keyboard package. \cr\cr
}
\details{
(1) For get.oc.kb() and get.oc.comb.kb(), the operating characteristics of
the Keyboard design, which include: \cr
(i) the overall dose selection percentage of the simulations generated, \cr
(ii) the number of patients treated at each dose, and \cr
(iii) the toxicities presented at each dose. \cr\cr
(2) For get.oc.obd.kb() and get.oc.obd2.kb(), the operating characteristics of the Keyboard design for phase I/II, which includes: \cr
(i) the overall dose selection percentage of the simulations generated, \cr
(ii) the number of patients treated at each dose,  \cr
(iii) the toxicities presented at each dose, and \cr
(iv) the efficacies presented at each dose. \cr\cr
(3) For select.mtd.kb() and select.mtd.comb.kb(): an infographic showing the
estimates of the toxicity probability for each dose, with corresponding
95\% credible intervals.
}
\examples{
\donttest{
### Single-agent trial ###

## Get the operating characteristics for a Keyboard single-agent trial
oc <- get.oc.kb(target=0.3, p.true=c(0.05, 0.15, 0.3, 0.45, 0.6),
                ncohort=10, cohortsize=3, ntrial=1000)
summary.kb(oc)

plot.kb(oc)
plot.kb(oc$selpercent)
plot.kb(oc$npatients)
plot.kb(oc$ntox)

## Select the MTD based on a trial's data
n <- c(3, 3, 15, 9, 0)
y <- c(0, 0, 4, 4, 0)
selmtd <- select.mtd.kb(target=0.3, npts=n, ntox=y)
summary.kb(selmtd)

plot.kb(selmtd)


### Drug-combination trial ###

## Get the operating characteristics for a Keyboard drug-combination trial
p.true <- matrix(c(0.01, 0.03, 0.10, 0.20, 0.30,
                   0.03, 0.05, 0.15, 0.30, 0.60,
                   0.08, 0.10, 0.30, 0.60, 0.75), byrow=TRUE, ncol=5)
oc.comb <- get.oc.comb.kb(target=0.3, p.true=p.true, ncohort=20, 
 cohortsize=3, n.earlystop=12, startdose=c(1, 1), ntrial=100)
summary.kb(oc.comb)

plot.kb(oc.comb)
plot.kb(oc.comb$selpercent)
plot.kb(oc.comb$nptsdose)
plot.kb(oc.comb$ntoxdose)

## Select the MTD based on a trial's data
n <- matrix(c(3, 5, 0, 0, 0,
              7, 6, 15, 0, 0,
              0, 0, 4, 0, 0), ncol=5, byrow=TRUE)
y <- matrix(c(0, 1, 0, 0, 0,
              1, 1, 4, 0, 0,
              0, 0, 2, 0, 0), ncol=5, byrow=TRUE)
sel.comb <- select.mtd.comb.kb(target=0.3, npts=n, ntox=y)
summary.kb(sel.comb)

plot.kb(sel.comb)

### oc.obd.kb
toxicity.low <- 0.15
toxicity.moderate <- 0.33
toxicity.high <- 0.40
efficacy.low <- 0.20
efficacy.moderate <- 0.40
efficacy.high <- 0.60
target.toxicity <- 0.30
target.efficacy <- 0.40
p.true <-c(0.08,0.30,0.60,0.80)
q.true <- c(0.25,0.40,0.25,0.50)
oc.obd.kb <- get.oc.obd.kb(toxicity.low = toxicity.low,
             toxicity.moderate= toxicity.moderate,
             toxicity.high = toxicity.high,
             efficacy.low = efficacy.low,
             efficacy.moderate = efficacy.moderate,
             efficacy.high = efficacy.high,
             target.toxicity=target.toxicity,
             target.efficacy= target.efficacy,
             p.true= p.true, q.true= q.true)
summary.kb(oc.obd.kb)
plot.kb(oc.obd.kb)
plot.kb(oc.obd.kb$selpercent1)
plot.kb(oc.obd.kb$selpercent2)
plot.kb(oc.obd.kb$selpercent3)
plot.kb(oc.obd.kb$npatients)
plot.kb(oc.obd.kb$ntox)
plot.kb(oc.obd.kb$neff)
}
}
\seealso{
\code{\link{summary.kb}}
}
\author{
Hongying Sun, Li Tang, and Haitao Pan
}
