/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.morph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.AnalysisOutputComparator;
import org.apache.lucene.analysis.kr.morph.CompoundEntry;
import org.apache.lucene.analysis.kr.morph.CompoundNounAnalyzer;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.morph.WordEntry;
import org.apache.lucene.analysis.kr.utils.ConstraintUtil;
import org.apache.lucene.analysis.kr.utils.DictionaryUtil;
import org.apache.lucene.analysis.kr.utils.EomiUtil;
import org.apache.lucene.analysis.kr.utils.IrregularUtil;
import org.apache.lucene.analysis.kr.utils.MorphUtil;
import org.apache.lucene.analysis.kr.utils.NounUtil;
import org.apache.lucene.analysis.kr.utils.SyllableUtil;
import org.apache.lucene.analysis.kr.utils.VerbUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MorphAnalyzer {
    public static final int POS_START = 1;
    public static final int POS_MID = 2;
    public static final int POS_END = 3;
    private CompoundNounAnalyzer cnAnalyzer = new CompoundNounAnalyzer();

    public MorphAnalyzer() {
        this.cnAnalyzer.setExactMach(false);
    }

    public void setExactCompound(boolean is) {
        this.cnAnalyzer.setExactMach(is);
    }

    public List analyze(String input) throws MorphException {
        if (input.endsWith(".")) {
            return this.analyze(input.substring(0, input.length() - 1), 3);
        }
        return this.analyze(input, 2);
    }

    public List analyze(String input, int pos) throws MorphException {
        ArrayList<AnalysisOutput> candidates = new ArrayList<AnalysisOutput>();
        boolean isVerbOnly = MorphUtil.hasVerbOnly(input);
        this.analysisByRule(input, candidates);
        if (!isVerbOnly || candidates.size() == 0) {
            this.addSingleWord(input, candidates);
        }
        Collections.sort(candidates, new AnalysisOutputComparator());
        boolean changed = false;
        boolean correct = false;
        for (AnalysisOutput o : candidates) {
            if (o.getScore() == 100) {
                if (o.getPatn() != 2) {
                    correct = true;
                }
                if (o.getPatn() != 3) continue;
                break;
            }
            if (o.getPatn() > 11 || o.getStem().length() <= 2) continue;
            if (!correct || o.getPatn() != 1) {
                this.confirmCNoun(o);
            }
            if (o.getScore() != 100) continue;
            changed = true;
        }
        if (changed) {
            Collections.sort(candidates, new AnalysisOutputComparator());
        }
        ArrayList<AnalysisOutput> results = new ArrayList<AnalysisOutput>();
        boolean hasCorrect = false;
        boolean hasCorrectNoun = false;
        boolean correctCnoun = false;
        HashMap<String, AnalysisOutput> stems = new HashMap<String, AnalysisOutput>();
        AnalysisOutput noun = null;
        double ratio = 0.0;
        AnalysisOutput compound = null;
        for (AnalysisOutput o : candidates) {
            if (o.getScore() == 0) continue;
            if (o.getScore() == 100 && o.getPos() != 'N') {
                this.addResults(o, results, stems);
                hasCorrect = true;
                continue;
            }
            if (o.getPos() == 'N' && o.getScore() == 100) {
                if ((hasCorrect || correctCnoun) && o.getCNounList().size() > 0) continue;
                if (o.getPos() == 'N') {
                    this.addResults(o, results, stems);
                } else if (noun == null) {
                    this.addResults(o, results, stems);
                    noun = o;
                } else if (o.getPatn() == 1 || o.getPatn() > noun.getPatn() || o.getPatn() == noun.getPatn() && o.getJosa() != null && noun.getJosa() != null && o.getJosa().length() > noun.getJosa().length()) {
                    results.remove(noun);
                    this.addResults(o, results, stems);
                    noun = o;
                }
                hasCorrectNoun = true;
                continue;
            }
            if (o.getPos() == 'N' && o.getCNounList().size() > 0 && !hasCorrect && !hasCorrectNoun) {
                double curatio = NounUtil.countFoundNouns(o);
                if (!(ratio < curatio) || compound != null && (compound == null || compound.getJosa() != null)) continue;
                ratio = curatio;
                compound = o;
                continue;
            }
            if (o.getPos() == 'N' && !hasCorrect && !hasCorrectNoun && compound == null) {
                this.addResults(o, results, stems);
                continue;
            }
            if (o.getPatn() != 3) continue;
            this.addResults(o, results, stems);
        }
        if (compound != null) {
            this.addResults(compound, results, stems);
        }
        if (results.size() == 0) {
            AnalysisOutput output = new AnalysisOutput(input, null, null, 1, 30);
            output.setPos('N');
            results.add(output);
        }
        return results;
    }

    private void analysisByRule(String input, List candidates) throws MorphException {
        boolean josaFlag = true;
        boolean eomiFlag = true;
        int strlen = input.length();
        boolean isVerbOnly = false;
        this.analysisWithEomi(input, "", candidates);
        int i = strlen - 1;
        while (i > 0) {
            String stem = input.substring(0, i);
            String eomi = input.substring(i);
            char[] feature = SyllableUtil.getFeature(eomi.charAt(0));
            if (!isVerbOnly && josaFlag && feature[SyllableUtil.IDX_JOSA1] == '1') {
                this.analysisWithJosa(stem, eomi, candidates);
            }
            if (eomiFlag) {
                this.analysisWithEomi(stem, eomi, candidates);
            }
            if (josaFlag && feature[SyllableUtil.IDX_JOSA2] == '0') {
                josaFlag = false;
            }
            if (eomiFlag && feature[SyllableUtil.IDX_EOMI2] == '0') {
                eomiFlag = false;
            }
            if (!josaFlag && !eomiFlag) break;
            --i;
        }
    }

    private void addResults(AnalysisOutput o, List results, HashMap<String, AnalysisOutput> stems) {
        AnalysisOutput old = stems.get(o.getStem());
        if (old == null || old.getPos() != o.getPos()) {
            results.add(o);
            stems.put(o.getStem(), o);
        } else if (old.getPatn() < o.getPatn()) {
            results.remove(old);
            results.add(o);
            stems.put(o.getStem(), o);
        }
    }

    private void addSingleWord(String word, List<AnalysisOutput> candidates) throws MorphException {
        AnalysisOutput output = new AnalysisOutput(word, null, null, 1);
        output.setPos('N');
        WordEntry entry = DictionaryUtil.getWord(word);
        if (entry != null) {
            if (entry.getFeature(0) != '1' && entry.getFeature(2) == '1') {
                AnalysisOutput busa = new AnalysisOutput(word, null, null, 21);
                busa.setPos('Z');
                busa.setScore(100);
                candidates.add(0, busa);
            } else if (entry.getFeature(0) == '1') {
                output.setScore(100);
                candidates.add(0, output);
            } else if (entry.getFeature(0) == '2') {
                candidates.add(0, output);
            }
            if (entry.getFeature(1) != '1') {
                return;
            }
        } else if (candidates.size() == 0 || !NounUtil.endsWith2Josa(word)) {
            output.setScore(30);
            candidates.add(output);
        }
    }

    public void analysisWithJosa(String stem, String end, List candidates) throws MorphException {
        if (stem == null || stem.length() == 0) {
            return;
        }
        char[] chrs = MorphUtil.decompose(stem.charAt(stem.length() - 1));
        if (!DictionaryUtil.existJosa(end) || chrs.length == 3 && ConstraintUtil.isTwoJosa(end) || chrs.length == 2 && ConstraintUtil.isThreeJosa(end) || "".equals(end)) {
            return;
        }
        AnalysisOutput output = new AnalysisOutput(stem, end, null, 2);
        output.setPos('N');
        boolean success = false;
        try {
            success = NounUtil.analysisMJ(output.clone(), candidates);
        }
        catch (CloneNotSupportedException e) {
            throw new MorphException(e.getMessage(), e);
        }
        WordEntry entry = DictionaryUtil.getWordExceptVerb(stem);
        if (entry != null) {
            output.setScore(100);
            if (entry.getFeature(0) == '0' && entry.getFeature(2) == '1') {
                output.setPos('Z');
                output.setPatn(22);
            }
        } else if (MorphUtil.hasVerbOnly(stem)) {
            return;
        }
        candidates.add(output);
    }

    public void analysisWithEomi(String stem, String end, List candidates) throws MorphException {
        String[] morphs = EomiUtil.splitEomi(stem, end);
        if (morphs[0] == null) {
            return;
        }
        String[] pomis = EomiUtil.splitPomi(morphs[0]);
        AnalysisOutput o = new AnalysisOutput(pomis[0], null, morphs[1], 11);
        o.setPomi(pomis[1]);
        try {
            String[] irrs;
            WordEntry entry = DictionaryUtil.getVerb(o.getStem());
            if (!(entry == null || "\uc744".equals(end) && entry.getFeature(9) == 'U')) {
                AnalysisOutput output = o.clone();
                output.setScore(100);
                MorphUtil.buildPtnVM(output, candidates);
                char[] features = SyllableUtil.getFeature(stem.charAt(stem.length() - 1));
                if (features[SyllableUtil.IDX_YNPLN] == '0' || morphs[1].charAt(0) != '\u3134') {
                    return;
                }
            }
            if ((irrs = IrregularUtil.restoreIrregularVerb(o.getStem(), o.getPomi() == null ? o.getEomi() : o.getPomi())) != null) {
                AnalysisOutput output = o.clone();
                output.setStem(irrs[0]);
                if (output.getPomi() == null) {
                    output.setEomi(irrs[1]);
                } else {
                    output.setPomi(irrs[1]);
                }
                output.setScore(100);
                MorphUtil.buildPtnVM(output, candidates);
            }
            if (VerbUtil.ananlysisNSM(o.clone(), candidates)) {
                return;
            }
            if (VerbUtil.ananlysisNSMXM(o.clone(), candidates)) {
                return;
            }
            if (VerbUtil.ananlysisNJCM(o.clone(), candidates)) {
                return;
            }
            if (VerbUtil.analysisVMCM(o.clone(), candidates)) {
                return;
            }
            VerbUtil.analysisVMXM(o.clone(), candidates);
        }
        catch (CloneNotSupportedException e) {
            throw new MorphException(e.getMessage(), e);
        }
    }

    public void analysisCNoun(List<AnalysisOutput> candidates) throws MorphException {
        boolean success = false;
        for (AnalysisOutput o : candidates) {
            if (o.getPos() != 'N') continue;
            if (o.getScore() == 100) {
                success = true;
                continue;
            }
            if (success) continue;
            this.confirmCNoun(o);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean confirmCNoun(AnalysisOutput o) throws MorphException {
        if (o.getStem().length() < 3) {
            return false;
        }
        WordEntry cnoun = DictionaryUtil.getCNoun(o.getStem());
        if (cnoun != null && cnoun.getFeature(0) == '2') {
            o.addCNoun(cnoun.getCompounds());
            o.setScore(100);
            return true;
        }
        List results = this.cnAnalyzer.analyze(o.getStem());
        boolean success = false;
        if (results.size() > 1) {
            o.setCNoun(results);
            success = true;
            for (CompoundEntry entry : results) {
                if (entry.isExist()) continue;
                success = false;
            }
            o.setScore(70);
        }
        if (success) {
            if (this.constraint(o)) {
                o.setScore(100);
                return success;
            }
            o.setScore(0);
            return false;
        }
        if (NounUtil.confirmDNoun(o) && o.getScore() != 100) {
            this.confirmCNoun(o);
        }
        if (o.getScore() == 100) {
            success = true;
        }
        if (o.getCNounList().size() <= 0) return success;
        if (this.constraint(o)) return success;
        o.setScore(0);
        return success;
    }

    private boolean constraint(AnalysisOutput o) throws MorphException {
        WordEntry entry;
        List<CompoundEntry> cnouns = o.getCNounList();
        return !("\ud654\ud574".equals(cnouns.get(cnouns.size() - 1).getWord()) ? !ConstraintUtil.canHaheCompound(cnouns.get(cnouns.size() - 2).getWord()) : o.getPatn() == 3 && ("\ub0b4".equals(o.getVsfx()) && cnouns.get(cnouns.size() - 1).getWord().length() != 1 ? (entry = DictionaryUtil.getWord(cnouns.get(cnouns.size() - 1).getWord())) != null && entry.getFeature(5) == '0' : "\ud558".equals(o.getVsfx()) && cnouns.get(cnouns.size() - 1).getWord().length() == 1));
    }
}

