% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_STAGED_BLOCKS.R
\name{staged.blocks}
\alias{staged.blocks}
\title{Staged blocks regression}
\usage{
staged.blocks(method, target, db, blocks, reg.type = "ols", p.value = 0.05)
}
\arguments{
\item{method}{Regression method applied on each block.
Available methods: \code{"stepFWD"} or \code{"stepRPC"}.}

\item{target}{Name of target variable within \code{db} argument.}

\item{db}{Modeling data with risk factors and target variable.}

\item{blocks}{Data frame with defined risk factor groups. It has to contain the following columns: \code{rf} and
\code{block}.}

\item{reg.type}{Regression type. Available options are: \code{"ols"} for OLS regression and \code{"frac.logit"} for
fractional logistic regression. Default is \code{"ols"}. For \code{"frac.logit"} option, target has to have
all values between 0 and 1.}

\item{p.value}{Significance level of p-value for the estimated coefficient. For numerical risk factors this value is
is directly compared to p-value of the estimated coefficient, while for categorical
multiple Wald test is employed and its p-value is used for comparison with selected threshold (\code{p.value}).}
}
\value{
The command \code{staged.blocks} returns a list of three objects.\cr
The first object (\code{model}) is the list of the models of each block (an object of class inheriting from \code{"lm"}).\cr
The second object (\code{steps}), is the data frame with risk factors selected from the each block.\cr
The third object (\code{dev.db}), returns the list of block's model development databases.\cr
}
\description{
\code{staged.blocks} performs blockwise regression where the predictions of each blocks' model is used as an
offset for the model of the following block.
}
\examples{
library(LGDtoolkit)
data(lgd.ds.c)
#stepwise with continuous risk factors
set.seed(123)
blocks <- data.frame(rf = names(lgd.ds.c)[!names(lgd.ds.c)\%in\%"lgd"], 
		   block = sample(1:3, ncol(lgd.ds.c) - 1, rep = TRUE))
blocks <- blocks[order(blocks$block, blocks$rf), ]
res <- LGDtoolkit::staged.blocks(method = "stepFWD", 
		   target = "lgd",
		   db = lgd.ds.c,
		   reg.type = "ols", 
		   blocks = blocks,
		   p.value = 0.05)
names(res)
res$models
summary(res$models[[3]])
identical(unname(predict(res$models[[1]], newdata = res$dev.db[[1]])),
    res$dev.db[[2]]$offset.vals)

}
\seealso{
\code{\link{embedded.blocks}}, \code{\link{ensemble.blocks}}, \code{\link{stepFWD}} and \code{\link{stepRPC}}.
}
