% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LaPSO.R
\name{LaPSO}
\alias{LaPSO}
\title{Particle Swarm Optimization for LHD}
\usage{
LaPSO(n, k, m, N, SameNumP, SameNumG, p0, p = 15, q = 1)
}
\arguments{
\item{n}{A positive integer.}

\item{k}{A positive integer.}

\item{m}{A positive integer.}

\item{N}{A positive integer.}

\item{SameNumP}{A non-negative integer.}

\item{SameNumG}{A non-negative integer.}

\item{p0}{A probability.}

\item{p}{A positive integer.}

\item{q}{The default is set to be 1, and it could be either 1 or 2.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} LHD.
}
\description{
\code{LaPSO} returns a maximin distance LHD constructed by particle swarm optimization algorithm (PSO)
}
\details{
\itemize{
\item \code{n} stands for the number of rows (or run size).
\item \code{k} stands for the number of columns (or the number of factors).
\item \code{m} stands for the number of particles.
\item \code{N} stands for the number of iterations.
\item \code{SameNumP} stands for how many elements in current column of current particle LHD should be the same as corresponding Personal Best. SameNumP=0, 1, 2, ..., n, and 0 means to skip the "exchange".
\item \code{SameNumG} stands for how many elements in current column of current particle LHD should be the same as corresponding Global Best. SameNumP=0, 1, 2, ..., n, and 0 means to skip the "exchange".
\item \code{SameNumP} and \code{SameNumG} cannot be 0 at the same time.
\item \code{p0} stands the probability of exchange two randomly selected elements in current column of current particle LHD.
\item \code{p} is the parameter in the phi_p formula, and \code{p} is prefered to be large.
\item If \code{q} is 1 (the default setting), \code{dij} is the rectangular distance. If \code{q} is 2, \code{dij} is the Euclidean distance.
}
}
\note{
Here are some general suggestions about the parameters: \itemize{
\item \code{SameNumP} is approximately \code{n}/2 when \code{SameNumG} is 0.
\item \code{SameNumG} is approximately \code{n}/4 when \code{SameNumP} is 0.
\item \code{p0} * (\code{k} - 1) = 1 or 2 is often sufficient. So \code{p0} = 1/(\code{k} - 1) or 2/(\code{k} - 1).
}
}
\examples{
#create a 8 by 3 maximin distance LHD, with # of particles and iterations = 10, when SameNumG is 0
tryLaPSO1=LaPSO(n=8,k=3,m=10,N=10,SameNumP=8/2,SameNumG=0,p0=1/(3-1),p=15,q=1)
tryLaPSO1
phi_p(tryLaPSO1,p=15,q=1)   #calculate the phi_p of "tryLaPSO1".

#create a 8 by 3 maximin distance LHD, with # of particles and iterations = 10, when SameNumP is 0
tryLaPSO2=LaPSO(n=8,k=3,m=10,N=10,SameNumP=0,SameNumG=8/4,p0=1/(3-1),p=15,q=1)
tryLaPSO2
phi_p(tryLaPSO2,p=14,q=1)   #calculate the phi_p of "tryLaPSO2".
}
\references{
Chen, R.-B., Hsieh, D.-N., Hung, Y., and Wang, W. (2013) Optimizing Latin hypercube designs by particle swarm. \emph{Stat. Comput.}, \strong{23}, 663-676.
}
