% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm.create.HTML.visualization.R
\name{table.llm.html}
\alias{table.llm.html}
\title{Create the HTML code for Logit Leaf Model visualization}
\usage{
table.llm.html(object, headertext = "The Logit Leaf Model",
  footertext = "A table footer comment", roundingnumbers = 2)
}
\arguments{
\item{object}{An object of class logitleafmodel, as that created by the function llm.}

\item{headertext}{Allows to provide the table with a header.}

\item{footertext}{Allows to provide the table with a custom footer.}

\item{roundingnumbers}{An integer stating the number of decimals in the visualization.}
}
\value{
Generates HTML code for a visualization.
}
\description{
This function generates HTML code for a visualization of the logit leaf model.
}
\examples{
## Load PimaIndiansDiabetes dataset from mlbench package
if (requireNamespace("mlbench", quietly = TRUE)) {
  library("mlbench")
}
data("PimaIndiansDiabetes")
## Split in training and test (2/3 - 1/3)
idtrain <- c(sample(1:768,512))
PimaTrain <-PimaIndiansDiabetes[idtrain,]
Pimatest <-PimaIndiansDiabetes[-idtrain,]
## Create the LLM
Pima.llm <- llm(X = PimaTrain[,-c(9)],Y = PimaTrain$diabetes,
 threshold_pruning = 0.25,nbr_obs_leaf = 100)
## Save the output of the model to a html file
Pima.Viz <- table.llm.html(object = Pima.llm, headertext = "This is an example of the LLM model",
footertext = "Enjoy the package!")
## Optionaly write it to your working directory
# write(Pima.Viz, "Visualization_LLM_on_PimaIndiansDiabetes.html")
}
\references{
Arno De Caigny, Kristof Coussement, Koen W. De Bock, A New Hybrid Classification Algorithm for Customer Churn Prediction Based on Logistic Regression and Decision Trees, European Journal of Operational Research (2018), doi: 10.1016/j.ejor.2018.02.009.
}
\seealso{
\code{\link{predict.llm}}, \code{\link{llm}}, \code{\link{llm.cv}}
}
\author{
Arno De Caigny, \email{a.de-caigny@ieseg.fr}, Kristof Coussement, \email{k.coussement@ieseg.fr} and Koen W. De Bock, \email{kdebock@audencia.com}
}
