% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmn_marg.R
\name{lmn_marg}
\alias{lmn_marg}
\title{Marginal log-posterior for the LMN model.}
\usage{
lmn_marg(suff, prior, post)
}
\arguments{
\item{suff}{An object of class \code{lmn_suff} (see \code{\link[=lmn_suff]{lmn_suff()}}).}

\item{prior}{A list with elements \code{Lambda}, \code{Omega}, \code{Psi}, \code{nu} corresponding to the parameters of the prior MNIW distribution.  See \code{\link[=lmn_prior]{lmn_prior()}}.}

\item{post}{A list with elements \code{Lambda}, \code{Omega}, \code{Psi}, \code{nu} corresponding to the parameters of the posterior MNIW distribution.  See \code{\link[=lmn_post]{lmn_post()}}.}
}
\value{
The scalar value of the marginal log-posterior.
}
\description{
Marginal log-posterior for the LMN model.
}
\examples{
# generate data
n <- 50
q <- 2
p <- 3
Y <- matrix(rnorm(n*q),n,q) # response matrix
X <- matrix(rnorm(n*p),n,p) # covariate matrix
V <- .5 * exp(-(1:n)/n) # Toeplitz variance specification

suff <- lmn_suff(Y = Y, X = X, V = V, Vtype = "acf") # sufficient statistics
# default noninformative prior pi(Beta, Sigma) ~ |Sigma|^(-(q+1)/2)
prior <- lmn_prior(p = suff$p, q = suff$q)
post <- lmn_post(suff, prior = prior) # posterior MNIW parameters
lmn_marg(suff, prior = prior, post = post)
}
