% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPfitProf.R
\name{LPfitProf}
\alias{LPfitProf}
\title{Profile likelihood estimation of a lognormal-Pareto mixture}
\usage{
LPfitProf(y, minRank, nboot)
}
\arguments{
\item{y}{numerical vector: random sample from the mixture.}

\item{minRank}{integer: minimum possible rank of the threshold.}

\item{nboot}{number of bootstrap replications used for estimating the standard errors. If omitted, no standard errors are computed.}
}
\value{
A list with the following elements:

xmin: estimated threshold.

prior: estimated mixing weight.

postProb: matrix of posterior probabilities.

alpha: estimated Pareto shape parameter.

mu: estimated expectation of the lognormal distribution on the lognormal scale.

sigma: estimated standard deviation of the lognormal distribution on the lognormal scale.

loglik: maximized log-likelihood.

nit: number of iterations.

npareto: estimated number of Pareto observations.

bootstd: bootstrap standard errors of the estimators.
}
\description{
This function fits a lognormal-Pareto mixture by maximizing the profile log-likelihood.
}
\details{
Estimation is implemented as in Bee (2022). As of standard errors, at each bootstrap replication the mixture is estimated with thresholds equal to ys(minRank), ys(minRank+1),..., ys(n),
where n is the sample size and ys is the sample sorted in ascending order. The latter procedure is implemented via parallel computing.
If the algorithm does not converge in 1000 iterations, a message is displayed.
}
\examples{
mixFit <- LPfitProf(TN2016,90,0)
}
\references{
{
\insertRef{bee24a}{LNPar}
}
}
