% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt_corr.R
\name{wt.corr}
\alias{wt.corr}
\title{Weighted correlation}
\source{
\url{https://en.wikipedia.org/wiki/Pearson_correlation_coefficient#Weighted_correlation_coefficient}
}
\usage{
wt.corr(x, y, w)
}
\arguments{
\item{x}{a vector}

\item{y}{a vector with same length of x}

\item{w}{a vector with same length of x and y}
}
\value{
a numerical value of weighted Pearson correlation
}
\description{
This function computes weighted Pearson correlation between two vectors with weights given. The output is between -1 and 1 with 1
being highly positively correlated, -1 being highly negatively correlated, and 0 being no correlation
}
\examples{
wt.corr(c(1, 2, -9, 4, 5), c(2:6), c(0.5, 1, 2, 0.5, 2))
wt.corr(rnorm(5), rnorm(5), runif(5, 0, 1))

}
