\name{pLRcontrast}
\alias{pLRcontrast}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Simulate p-values for LR contrast tests in regression models with a lack of identifiability.
}
\description{
The function simulates p-values for LR contrast tests. The competing models can be specified by the argument 'models' 
(see \code{\link[DoseFinding]{drmodels}}) and by 'nsim' you can specify how many simulations should be done. It is 
recommended to do about 10000 but notice that the simulation can take some time. If the parameter 'info' is set 
'TRUE', information of the progress will be shown.
}
\usage{
pLRcontrast(dose, resp, models, off = 0.01 * max(dose), scal = 1.2 * max(dose), 
            nsim = 1000, info = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dose, resp}{
Vectors of equal length specifying dose and response values.
}
  \item{models}{
A subvector of c("linear", "emax", "exponential", "linlog", "sigEmax", "quadratic", "betaMod", "logistic") (see \code{\link[DoseFinding]{drmodels}})
which specifies the competing models.
}
  \item{off}{
Positive and fixed offset parameter in the 'linlog' model (see \code{\link[DoseFinding]{drmodels}}).
}
  \item{scal}{
Positive and fixed dose scaling parameter in the 'betaMod' with '\eqn{scal\ge} max(dose)' (see \code{\link[DoseFinding]{drmodels}}).
}
  \item{nsim}{
A positive integer which specifies the number of simulations that should be done.
}
  \item{info}{
Logical value which indicates whether progress information should be shown.
}
}
\value{
A matrix containing the unadjusted and adjusted p-value for one model in each row.
}
\references{
Dette, H., Titoff, S., Volgushev, S. and Bretz, F. (2015), Dose
response signal detection under model uncertainty. Biometrics. doi:
10.1111/biom.12357
}
\author{
Kevin Kokot
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link[DoseFinding:DoseFinding-package]{DoseFinding}}
}
\examples{
# In this case the data is generated by the constant model, i.e. the 
# null hypothesis of no dose response is true.

resp <- rnorm(n = 50, mean = 0.2)
dose <- c(rep(0, 10), rep(0.05, 10), rep(0.2, 10), rep(0.6, 10), rep(1, 10))

# Calculate the p-values in this scenario
			 
pLRcontrast(dose = dose, resp = resp, models = c("linear", "emax", 
            "exponential", "linlog"), nsim = 10)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
