% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_dates.R
\name{expand_dates}
\alias{expand_dates}
\title{Expand a data.frame to include all dates between a start and end value
defined by parameters x and y}
\usage{
expand_dates(df, start, end)
}
\arguments{
\item{df}{Input data.frame}

\item{start}{start date}

\item{end}{end date}
}
\value{
A data.frame/tibble containing all variables of the input data.frame
as well as a new variable, \code{date}, with repeated rows for each date between
\code{start} and \code{end}.
}
\description{
Expand a data.frame to include all dates between a start and end value
defined by parameters x and y
}
\examples{
library(LTASR)
data <- data.frame(start = as.Date('3/1/2015', format='\%m/\%d/\%Y'),
                     end = as.Date('3/15/2015', format='\%m/\%d/\%Y'))
expand_dates(data, start, end)

}
