% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example-data.R
\docType{data}
\name{math_example}
\alias{math_example}
\title{Dataset for the example in function 'LVGP_fit'}
\format{A named list containing training and test data:
\describe{
  \item{"X_tr"}{24-by-3 matrix for 24 training data inputs, 3rd column being the qualitative variable}
  \item{"Y_tr"}{24-by-1 matrix for 24 training data outputs}
  \item{"X_te"}{90-by-3 matrix for 90 testing data inputs, 3rd column being the qualitative variable}
  \item{"Y_te"}{90-by-1 matrix for 90 testing data outputs}
}}
\source{
The dataset can be generated with the code at the end of this description file.
}
\usage{
data(math_example)
}
\description{
Data are sampled from the modified math function based on the first example in the paper listed in code{references}.
There are still 2 quantitative and 1 qualitative variables, but the qualitative variable has only 3 levels.
For each level, there are 8 training data points and 30 testing data points, all generated with Latin hypercube sampling.
In total, there are 24 training data points and 90 testing data points.
}
\examples{
data(math_example)
X_tr <- math_example$X_tr
Y_tr <- math_example$Y_tr
X_te <- math_example$X_te
Y_te <- math_example$Y_te
}
\references{
\enumerate{
\item "A Latent Variable Approach to Gaussian Process Modeling with Qualitative and Quantitative Factors", Yichi Zhang, Siyu Tao, Wei Chen, and Daniel W. Apley (\href{https://arxiv.org/abs/1806.07504}{arXiv})
}
}
\keyword{dataset}
\keyword{example}
