% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_recruits.R
\name{make_rec_fun}
\alias{make_rec_fun}
\title{Generate the stock recruitment functions}
\usage{
make_rec_fun(rec_fun = "hockey-stick")
}
\arguments{
\item{rec_fun}{A character vector representing the stock recruitment function to be applied to each species. The default is \code{"hockey-stick"}, but \code{rec_fun} can also take \code{"Ricker"}, \code{"Beverton-Holt"}, \code{"constant"}, or \code{"linear"} for each species.}
}
\value{
The stock recruitment function for a given species. If an invalid recruitment function is selected, \code{NULL} is returned and a warning message is shown.
}
\description{
Generates the stock recruitment function for a given species.
}
\details{
For \code{"Beverton-Holt"}, the stock recruitment function is defined as \code{a*SSB/(1+b*SSB)}; for \code{"Ricker"} it is defined as \code{a*SSB*exp(-b*SSB)}; for \code{"hockey-stick"} it is defined as \code{min(a*SSB, b)}; for \code{"constant"} it is defined as \code{a}, and for \code{"linear"} it is defined as \code{a*SSB}. In all cases, \code{SSB} is the Spawning Stock Biomass in 1000s of tonnes and \code{a} and \code{b} are parameters of the specific stock recruitment functions.
}
\examples{
# Run the function
make_rec_fun("Ricker")
}
\references{
Barrowman, N.J., Myers, R.A. (2000).  Still more spawner-recruit curves: the hockey stick and its generalisations. \emph{Canadian Journal of Fisheries and Aquatic Science}, 57:665–676.

Beverton, R.J.H., Holt, S.J. (1957). On the Dynamics of Exploited Fish Populations, volume 19 of Fisheries Investigations (Series 2). United Kingdom Ministry of Agriculture and Fisheries.

Hall, S. J., Collie, J. S., Duplisea, D. E., Jennings, S., Bravington, M., & Link, J. (2006). A length-based multispecies model for evaluating community responses to fishing. \emph{Canadian Journal of Fisheries and Aquatic Sciences}, 63(6):1344-1359.

Ogle, D.H. (2016). Introductory Fisheries Analyses with R. CRC Press.

Ricker, W.E. (1954). Stock and recruitment. \emph{Journal of the Fisheries Research Board of Canada}, 11:559-623.

Thorpe, R.B., Le Quesne, W.J.F., Luxford, F., Collie, J.S., Jennings, S. (2015). Evaluation and management implications of uncertainty in a multispecies size-structured model of population and community responses to fishing. \emph{Methods in Ecology and Evolution}, 6:49-58.
}
\seealso{
\code{\link{calc_recruits}}, \code{\link{get_rec_fun}}, \code{\link{rec_BH}}, \code{\link{rec_Ricker}}, \code{\link{rec_hockey}}, \code{\link{rec_const}}, \code{\link{rec_linear}} and \code{\link{calc_SSB}}
}
