% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initClusters.R
\name{initClusters}
\alias{initClusters}
\title{To initialize clusters for the divisive algorithm.}
\usage{
initClusters(initList)
}
\arguments{
\item{initList}{is a clusters list. It will contain clusters with one element.}
}
\value{
A cluster list.
}
\description{
To initialize clusters for the divisive algorithm.
}
\details{
This function will calculate every cluster that can be created by joining initial clusters with each other. It creates clusters
from length = 1 until a cluster with every element is created.

These clusters will be used to find the most different clusters that we can create by dividing the initial cluster.
}
\examples{

data <- c(1:8)

matrix <- matrix(data,ncol=2)

listData <- toListDivisive(data)

listMatrix <- toListDivisive(matrix)

initClusters(listData)

initClusters(listMatrix)

}
\author{
Roberto Alcántara \email{roberto.alcantara@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
